/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.UserFacingError;
import java.io.IOException;

public final class UserFacingWarningDetail
implements JsonSerializable<UserFacingWarningDetail> {
    private String resourceName;
    private UserFacingError warning;
    private static final ClientLogger LOGGER = new ClientLogger(UserFacingWarningDetail.class);

    public String resourceName() {
        return this.resourceName;
    }

    public UserFacingWarningDetail withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public UserFacingError warning() {
        return this.warning;
    }

    public UserFacingWarningDetail withWarning(UserFacingError warning) {
        this.warning = warning;
        return this;
    }

    public void validate() {
        if (this.warning() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property warning in model UserFacingWarningDetail"));
        }
        this.warning().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("warning", (JsonSerializable)this.warning);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        return jsonWriter.writeEndObject();
    }

    public static UserFacingWarningDetail fromJson(JsonReader jsonReader) throws IOException {
        return (UserFacingWarningDetail)jsonReader.readObject(reader -> {
            UserFacingWarningDetail deserializedUserFacingWarningDetail = new UserFacingWarningDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("warning".equals(fieldName)) {
                    deserializedUserFacingWarningDetail.warning = UserFacingError.fromJson(reader);
                    continue;
                }
                if ("resourceName".equals(fieldName)) {
                    deserializedUserFacingWarningDetail.resourceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserFacingWarningDetail;
        });
    }
}

