/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.InnerError;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class UserFacingError
implements JsonSerializable<UserFacingError> {
    private String code;
    private List<UserFacingError> details;
    private InnerError innerError;
    private Boolean isRetryable;
    private Boolean isUserError;
    private Map<String, String> properties;
    private String message;
    private List<String> recommendedAction;
    private String target;

    public String code() {
        return this.code;
    }

    public UserFacingError withCode(String code) {
        this.code = code;
        return this;
    }

    public List<UserFacingError> details() {
        return this.details;
    }

    public UserFacingError withDetails(List<UserFacingError> details) {
        this.details = details;
        return this;
    }

    public InnerError innerError() {
        return this.innerError;
    }

    public UserFacingError withInnerError(InnerError innerError) {
        this.innerError = innerError;
        return this;
    }

    public Boolean isRetryable() {
        return this.isRetryable;
    }

    public UserFacingError withIsRetryable(Boolean isRetryable) {
        this.isRetryable = isRetryable;
        return this;
    }

    public Boolean isUserError() {
        return this.isUserError;
    }

    public UserFacingError withIsUserError(Boolean isUserError) {
        this.isUserError = isUserError;
        return this;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public UserFacingError withProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public String message() {
        return this.message;
    }

    public UserFacingError withMessage(String message) {
        this.message = message;
        return this;
    }

    public List<String> recommendedAction() {
        return this.recommendedAction;
    }

    public UserFacingError withRecommendedAction(List<String> recommendedAction) {
        this.recommendedAction = recommendedAction;
        return this;
    }

    public String target() {
        return this.target;
    }

    public UserFacingError withTarget(String target) {
        this.target = target;
        return this;
    }

    public void validate() {
        if (this.details() != null) {
            this.details().forEach(e -> e.validate());
        }
        if (this.innerError() != null) {
            this.innerError().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innerError", (JsonSerializable)this.innerError);
        jsonWriter.writeBooleanField("isRetryable", this.isRetryable);
        jsonWriter.writeBooleanField("isUserError", this.isUserError);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("recommendedAction", this.recommendedAction, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("target", this.target);
        return jsonWriter.writeEndObject();
    }

    public static UserFacingError fromJson(JsonReader jsonReader) throws IOException {
        return (UserFacingError)jsonReader.readObject(reader -> {
            UserFacingError deserializedUserFacingError = new UserFacingError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedUserFacingError.code = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedUserFacingError.details = details = reader.readArray(reader1 -> UserFacingError.fromJson(reader1));
                    continue;
                }
                if ("innerError".equals(fieldName)) {
                    deserializedUserFacingError.innerError = InnerError.fromJson(reader);
                    continue;
                }
                if ("isRetryable".equals(fieldName)) {
                    deserializedUserFacingError.isRetryable = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isUserError".equals(fieldName)) {
                    deserializedUserFacingError.isUserError = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedUserFacingError.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedUserFacingError.message = reader.getString();
                    continue;
                }
                if ("recommendedAction".equals(fieldName)) {
                    List recommendedAction;
                    deserializedUserFacingError.recommendedAction = recommendedAction = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedUserFacingError.target = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserFacingError;
        });
    }
}

