/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.RestoreTargetLocationType;
import java.io.IOException;

public final class TargetDetails
implements JsonSerializable<TargetDetails> {
    private String filePrefix;
    private RestoreTargetLocationType restoreTargetLocationType;
    private String url;
    private String targetResourceArmId;
    private static final ClientLogger LOGGER = new ClientLogger(TargetDetails.class);

    public String filePrefix() {
        return this.filePrefix;
    }

    public TargetDetails withFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
        return this;
    }

    public RestoreTargetLocationType restoreTargetLocationType() {
        return this.restoreTargetLocationType;
    }

    public TargetDetails withRestoreTargetLocationType(RestoreTargetLocationType restoreTargetLocationType) {
        this.restoreTargetLocationType = restoreTargetLocationType;
        return this;
    }

    public String url() {
        return this.url;
    }

    public TargetDetails withUrl(String url) {
        this.url = url;
        return this;
    }

    public String targetResourceArmId() {
        return this.targetResourceArmId;
    }

    public TargetDetails withTargetResourceArmId(String targetResourceArmId) {
        this.targetResourceArmId = targetResourceArmId;
        return this;
    }

    public void validate() {
        if (this.filePrefix() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filePrefix in model TargetDetails"));
        }
        if (this.restoreTargetLocationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property restoreTargetLocationType in model TargetDetails"));
        }
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model TargetDetails"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filePrefix", this.filePrefix);
        jsonWriter.writeStringField("restoreTargetLocationType", this.restoreTargetLocationType == null ? null : this.restoreTargetLocationType.toString());
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("targetResourceArmId", this.targetResourceArmId);
        return jsonWriter.writeEndObject();
    }

    public static TargetDetails fromJson(JsonReader jsonReader) throws IOException {
        return (TargetDetails)jsonReader.readObject(reader -> {
            TargetDetails deserializedTargetDetails = new TargetDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filePrefix".equals(fieldName)) {
                    deserializedTargetDetails.filePrefix = reader.getString();
                    continue;
                }
                if ("restoreTargetLocationType".equals(fieldName)) {
                    deserializedTargetDetails.restoreTargetLocationType = RestoreTargetLocationType.fromString(reader.getString());
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedTargetDetails.url = reader.getString();
                    continue;
                }
                if ("targetResourceArmId".equals(fieldName)) {
                    deserializedTargetDetails.targetResourceArmId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetDetails;
        });
    }
}

