/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RestorableTimeRange
implements JsonSerializable<RestorableTimeRange> {
    private String startTime;
    private String endTime;
    private String objectType;
    private static final ClientLogger LOGGER = new ClientLogger(RestorableTimeRange.class);

    public String startTime() {
        return this.startTime;
    }

    public RestorableTimeRange withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public RestorableTimeRange withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String objectType() {
        return this.objectType;
    }

    public RestorableTimeRange withObjectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    public void validate() {
        if (this.startTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property startTime in model RestorableTimeRange"));
        }
        if (this.endTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endTime in model RestorableTimeRange"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("objectType", this.objectType);
        return jsonWriter.writeEndObject();
    }

    public static RestorableTimeRange fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableTimeRange)jsonReader.readObject(reader -> {
            RestorableTimeRange deserializedRestorableTimeRange = new RestorableTimeRange();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedRestorableTimeRange.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRestorableTimeRange.endTime = reader.getString();
                    continue;
                }
                if ("objectType".equals(fieldName)) {
                    deserializedRestorableTimeRange.objectType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableTimeRange;
        });
    }
}

