/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.fluent.models.ResourceGuardProxyBaseResourceInner;
import com.azure.resourcemanager.dataprotection.models.DppResourceList;
import java.io.IOException;
import java.util.List;

public final class ResourceGuardProxyBaseResourceList
extends DppResourceList {
    private List<ResourceGuardProxyBaseResourceInner> value;

    public List<ResourceGuardProxyBaseResourceInner> value() {
        return this.value;
    }

    public ResourceGuardProxyBaseResourceList withValue(List<ResourceGuardProxyBaseResourceInner> value) {
        this.value = value;
        return this;
    }

    @Override
    public ResourceGuardProxyBaseResourceList withNextLink(String nextLink) {
        super.withNextLink(nextLink);
        return this;
    }

    @Override
    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink());
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceGuardProxyBaseResourceList fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGuardProxyBaseResourceList)jsonReader.readObject(reader -> {
            ResourceGuardProxyBaseResourceList deserializedResourceGuardProxyBaseResourceList = new ResourceGuardProxyBaseResourceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceGuardProxyBaseResourceList.withNextLink(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceGuardProxyBaseResourceList.value = value = reader.readArray(reader1 -> ResourceGuardProxyBaseResourceInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGuardProxyBaseResourceList;
        });
    }
}

