/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ResourceGuardOperationDetail;
import java.io.IOException;
import java.util.List;

public final class ResourceGuardProxyBase
implements JsonSerializable<ResourceGuardProxyBase> {
    private String resourceGuardResourceId;
    private List<ResourceGuardOperationDetail> resourceGuardOperationDetails;
    private String lastUpdatedTime;
    private String description;

    public String resourceGuardResourceId() {
        return this.resourceGuardResourceId;
    }

    public ResourceGuardProxyBase withResourceGuardResourceId(String resourceGuardResourceId) {
        this.resourceGuardResourceId = resourceGuardResourceId;
        return this;
    }

    public List<ResourceGuardOperationDetail> resourceGuardOperationDetails() {
        return this.resourceGuardOperationDetails;
    }

    public ResourceGuardProxyBase withResourceGuardOperationDetails(List<ResourceGuardOperationDetail> resourceGuardOperationDetails) {
        this.resourceGuardOperationDetails = resourceGuardOperationDetails;
        return this;
    }

    public String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ResourceGuardProxyBase withLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ResourceGuardProxyBase withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.resourceGuardOperationDetails() != null) {
            this.resourceGuardOperationDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceGuardResourceId", this.resourceGuardResourceId);
        jsonWriter.writeArrayField("resourceGuardOperationDetails", this.resourceGuardOperationDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("lastUpdatedTime", this.lastUpdatedTime);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static ResourceGuardProxyBase fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceGuardProxyBase)jsonReader.readObject(reader -> {
            ResourceGuardProxyBase deserializedResourceGuardProxyBase = new ResourceGuardProxyBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceGuardResourceId".equals(fieldName)) {
                    deserializedResourceGuardProxyBase.resourceGuardResourceId = reader.getString();
                    continue;
                }
                if ("resourceGuardOperationDetails".equals(fieldName)) {
                    List resourceGuardOperationDetails;
                    deserializedResourceGuardProxyBase.resourceGuardOperationDetails = resourceGuardOperationDetails = reader.readArray(reader1 -> ResourceGuardOperationDetail.fromJson(reader1));
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedResourceGuardProxyBase.lastUpdatedTime = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedResourceGuardProxyBase.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceGuardProxyBase;
        });
    }
}

