/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class JobSubTask
implements JsonSerializable<JobSubTask> {
    private Map<String, String> additionalDetails;
    private int taskId;
    private String taskName;
    private String taskProgress;
    private String taskStatus;
    private static final ClientLogger LOGGER = new ClientLogger(JobSubTask.class);

    public Map<String, String> additionalDetails() {
        return this.additionalDetails;
    }

    public JobSubTask withAdditionalDetails(Map<String, String> additionalDetails) {
        this.additionalDetails = additionalDetails;
        return this;
    }

    public int taskId() {
        return this.taskId;
    }

    public JobSubTask withTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public String taskName() {
        return this.taskName;
    }

    public JobSubTask withTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public String taskProgress() {
        return this.taskProgress;
    }

    public String taskStatus() {
        return this.taskStatus;
    }

    public JobSubTask withTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
        return this;
    }

    public void validate() {
        if (this.taskName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskName in model JobSubTask"));
        }
        if (this.taskStatus() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property taskStatus in model JobSubTask"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("taskId", this.taskId);
        jsonWriter.writeStringField("taskName", this.taskName);
        jsonWriter.writeStringField("taskStatus", this.taskStatus);
        jsonWriter.writeMapField("additionalDetails", this.additionalDetails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static JobSubTask fromJson(JsonReader jsonReader) throws IOException {
        return (JobSubTask)jsonReader.readObject(reader -> {
            JobSubTask deserializedJobSubTask = new JobSubTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskId".equals(fieldName)) {
                    deserializedJobSubTask.taskId = reader.getInt();
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedJobSubTask.taskName = reader.getString();
                    continue;
                }
                if ("taskStatus".equals(fieldName)) {
                    deserializedJobSubTask.taskStatus = reader.getString();
                    continue;
                }
                if ("additionalDetails".equals(fieldName)) {
                    Map additionalDetails;
                    deserializedJobSubTask.additionalDetails = additionalDetails = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("taskProgress".equals(fieldName)) {
                    deserializedJobSubTask.taskProgress = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobSubTask;
        });
    }
}

