/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.DppBaseTrackedResource;
import com.azure.resourcemanager.dataprotection.models.DppIdentityDetails;
import java.io.IOException;
import java.util.Map;

public class DppTrackedResource
extends DppBaseTrackedResource {
    private DppIdentityDetails identity;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public DppIdentityDetails identity() {
        return this.identity;
    }

    public DppTrackedResource withIdentity(DppIdentityDetails identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public DppTrackedResource withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public DppTrackedResource withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public DppTrackedResource withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static DppTrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return (DppTrackedResource)((Object)jsonReader.readObject(reader -> {
            DppTrackedResource deserializedDppTrackedResource = new DppTrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDppTrackedResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDppTrackedResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDppTrackedResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDppTrackedResource.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDppTrackedResource.withTags(tags);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedDppTrackedResource.withEtag(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDppTrackedResource.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDppTrackedResource.identity = DppIdentityDetails.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDppTrackedResource;
        }));
    }
}

