/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.UserAssignedIdentity;
import java.io.IOException;
import java.util.Map;

public final class DppIdentityDetails
implements JsonSerializable<DppIdentityDetails> {
    private String principalId;
    private String tenantId;
    private String type;
    private Map<String, UserAssignedIdentity> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public String type() {
        return this.type;
    }

    public DppIdentityDetails withType(String type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public DppIdentityDetails withUserAssignedIdentities(Map<String, UserAssignedIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DppIdentityDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DppIdentityDetails)jsonReader.readObject(reader -> {
            DppIdentityDetails deserializedDppIdentityDetails = new DppIdentityDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedDppIdentityDetails.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedDppIdentityDetails.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDppIdentityDetails.type = reader.getString();
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedDppIdentityDetails.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDppIdentityDetails;
        });
    }
}

