/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CrossRegionRestoreJobRequest
implements JsonSerializable<CrossRegionRestoreJobRequest> {
    private String sourceRegion;
    private String sourceBackupVaultId;
    private String jobId;
    private static final ClientLogger LOGGER = new ClientLogger(CrossRegionRestoreJobRequest.class);

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public CrossRegionRestoreJobRequest withSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
        return this;
    }

    public String sourceBackupVaultId() {
        return this.sourceBackupVaultId;
    }

    public CrossRegionRestoreJobRequest withSourceBackupVaultId(String sourceBackupVaultId) {
        this.sourceBackupVaultId = sourceBackupVaultId;
        return this;
    }

    public String jobId() {
        return this.jobId;
    }

    public CrossRegionRestoreJobRequest withJobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public void validate() {
        if (this.sourceRegion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceRegion in model CrossRegionRestoreJobRequest"));
        }
        if (this.sourceBackupVaultId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceBackupVaultId in model CrossRegionRestoreJobRequest"));
        }
        if (this.jobId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property jobId in model CrossRegionRestoreJobRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceRegion", this.sourceRegion);
        jsonWriter.writeStringField("sourceBackupVaultId", this.sourceBackupVaultId);
        jsonWriter.writeStringField("jobId", this.jobId);
        return jsonWriter.writeEndObject();
    }

    public static CrossRegionRestoreJobRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CrossRegionRestoreJobRequest)jsonReader.readObject(reader -> {
            CrossRegionRestoreJobRequest deserializedCrossRegionRestoreJobRequest = new CrossRegionRestoreJobRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRegion".equals(fieldName)) {
                    deserializedCrossRegionRestoreJobRequest.sourceRegion = reader.getString();
                    continue;
                }
                if ("sourceBackupVaultId".equals(fieldName)) {
                    deserializedCrossRegionRestoreJobRequest.sourceBackupVaultId = reader.getString();
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedCrossRegionRestoreJobRequest.jobId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCrossRegionRestoreJobRequest;
        });
    }
}

