/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.fluent.models.ClientDiscoveryValueForSingleApiInner;
import java.io.IOException;
import java.util.List;

public final class ClientDiscoveryResponse
implements JsonSerializable<ClientDiscoveryResponse> {
    private String nextLink;
    private List<ClientDiscoveryValueForSingleApiInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public ClientDiscoveryResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public List<ClientDiscoveryValueForSingleApiInner> value() {
        return this.value;
    }

    public ClientDiscoveryResponse withValue(List<ClientDiscoveryValueForSingleApiInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClientDiscoveryResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ClientDiscoveryResponse)jsonReader.readObject(reader -> {
            ClientDiscoveryResponse deserializedClientDiscoveryResponse = new ClientDiscoveryResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedClientDiscoveryResponse.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedClientDiscoveryResponse.value = value = reader.readArray(reader1 -> ClientDiscoveryValueForSingleApiInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientDiscoveryResponse;
        });
    }
}

