/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.ClientDiscoveryForLogSpecification;
import java.io.IOException;
import java.util.List;

public final class ClientDiscoveryForServiceSpecification
implements JsonSerializable<ClientDiscoveryForServiceSpecification> {
    private List<ClientDiscoveryForLogSpecification> logSpecifications;

    public List<ClientDiscoveryForLogSpecification> logSpecifications() {
        return this.logSpecifications;
    }

    public ClientDiscoveryForServiceSpecification withLogSpecifications(List<ClientDiscoveryForLogSpecification> logSpecifications) {
        this.logSpecifications = logSpecifications;
        return this;
    }

    public void validate() {
        if (this.logSpecifications() != null) {
            this.logSpecifications().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("logSpecifications", this.logSpecifications, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ClientDiscoveryForServiceSpecification fromJson(JsonReader jsonReader) throws IOException {
        return (ClientDiscoveryForServiceSpecification)jsonReader.readObject(reader -> {
            ClientDiscoveryForServiceSpecification deserializedClientDiscoveryForServiceSpecification = new ClientDiscoveryForServiceSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logSpecifications".equals(fieldName)) {
                    List logSpecifications;
                    deserializedClientDiscoveryForServiceSpecification.logSpecifications = logSpecifications = reader.readArray(reader1 -> ClientDiscoveryForLogSpecification.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedClientDiscoveryForServiceSpecification;
        });
    }
}

