/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.models.DppResourceList;
import java.io.IOException;
import java.util.List;

public final class BackupInstanceResourceList
extends DppResourceList {
    private List<BackupInstanceResourceInner> value;

    public List<BackupInstanceResourceInner> value() {
        return this.value;
    }

    public BackupInstanceResourceList withValue(List<BackupInstanceResourceInner> value) {
        this.value = value;
        return this;
    }

    @Override
    public BackupInstanceResourceList withNextLink(String nextLink) {
        super.withNextLink(nextLink);
        return this;
    }

    @Override
    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink());
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static BackupInstanceResourceList fromJson(JsonReader jsonReader) throws IOException {
        return (BackupInstanceResourceList)jsonReader.readObject(reader -> {
            BackupInstanceResourceList deserializedBackupInstanceResourceList = new BackupInstanceResourceList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedBackupInstanceResourceList.withNextLink(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedBackupInstanceResourceList.value = value = reader.readArray(reader1 -> BackupInstanceResourceInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupInstanceResourceList;
        });
    }
}

