/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.FetchCrossRegionRestoreJobsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.AzureBackupJobResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionClientImpl;
import com.azure.resourcemanager.dataprotection.models.CrossRegionRestoreJobRequest;
import reactor.core.publisher.Mono;

public final class FetchCrossRegionRestoreJobsClientImpl
implements FetchCrossRegionRestoreJobsClient {
    private final FetchCrossRegionRestoreJobsService service;
    private final DataProtectionClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(FetchCrossRegionRestoreJobsClientImpl.class);

    FetchCrossRegionRestoreJobsClientImpl(DataProtectionClientImpl client) {
        this.service = (FetchCrossRegionRestoreJobsService)RestProxy.create(FetchCrossRegionRestoreJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureBackupJobResourceInner>> getWithResponseAsync(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AzureBackupJobResourceInner> getAsync(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        return this.getWithResponseAsync(resourceGroupName, location, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AzureBackupJobResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureBackupJobResourceInner> getWithResponse(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), resourceGroupName, this.client.getSubscriptionId(), location, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureBackupJobResourceInner get(String resourceGroupName, String location, CrossRegionRestoreJobRequest parameters) {
        return (AzureBackupJobResourceInner)((Object)this.getWithResponse(resourceGroupName, location, parameters, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataProtectionClientFetchCrossRegionRestoreJobs")
    public static interface FetchCrossRegionRestoreJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AzureBackupJobResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @BodyParam(value="application/json") CrossRegionRestoreJobRequest var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AzureBackupJobResourceInner> getSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="location") String var5, @BodyParam(value="application/json") CrossRegionRestoreJobRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

