/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.ExportJobsOperationResultsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.ExportJobsResultInner;
import com.azure.resourcemanager.dataprotection.implementation.ExportJobsResultImpl;
import com.azure.resourcemanager.dataprotection.models.ExportJobsOperationResults;
import com.azure.resourcemanager.dataprotection.models.ExportJobsResult;

public final class ExportJobsOperationResultsImpl
implements ExportJobsOperationResults {
    private static final ClientLogger LOGGER = new ClientLogger(ExportJobsOperationResultsImpl.class);
    private final ExportJobsOperationResultsClient innerClient;
    private final DataProtectionManager serviceManager;

    public ExportJobsOperationResultsImpl(ExportJobsOperationResultsClient innerClient, DataProtectionManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ExportJobsResult> getWithResponse(String resourceGroupName, String vaultName, String operationId, Context context) {
        Response<ExportJobsResultInner> inner = this.serviceClient().getWithResponse(resourceGroupName, vaultName, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ExportJobsResultImpl((ExportJobsResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public ExportJobsResult get(String resourceGroupName, String vaultName, String operationId) {
        ExportJobsResultInner inner = this.serviceClient().get(resourceGroupName, vaultName, operationId);
        if (inner != null) {
            return new ExportJobsResultImpl(inner, this.manager());
        }
        return null;
    }

    private ExportJobsOperationResultsClient serviceClient() {
        return this.innerClient;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }
}

