/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dataprotection.fluent.DataProtectionsClient;
import com.azure.resourcemanager.dataprotection.fluent.models.FeatureValidationResponseBaseInner;
import com.azure.resourcemanager.dataprotection.implementation.DataProtectionClientImpl;
import com.azure.resourcemanager.dataprotection.models.FeatureValidationRequestBase;
import reactor.core.publisher.Mono;

public final class DataProtectionsClientImpl
implements DataProtectionsClient {
    private final DataProtectionsService service;
    private final DataProtectionClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DataProtectionsClientImpl.class);

    DataProtectionsClientImpl(DataProtectionClientImpl client) {
        this.service = (DataProtectionsService)RestProxy.create(DataProtectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FeatureValidationResponseBaseInner>> checkFeatureSupportWithResponseAsync(String location, FeatureValidationRequestBase parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkFeatureSupport(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FeatureValidationResponseBaseInner> checkFeatureSupportAsync(String location, FeatureValidationRequestBase parameters) {
        return this.checkFeatureSupportWithResponseAsync(location, parameters).flatMap(res -> Mono.justOrEmpty((Object)((FeatureValidationResponseBaseInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FeatureValidationResponseBaseInner> checkFeatureSupportWithResponse(String location, FeatureValidationRequestBase parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.checkFeatureSupportSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FeatureValidationResponseBaseInner checkFeatureSupport(String location, FeatureValidationRequestBase parameters) {
        return (FeatureValidationResponseBaseInner)this.checkFeatureSupportWithResponse(location, parameters, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataProtectionClientDataProtections")
    public static interface DataProtectionsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/locations/{location}/checkFeatureSupport")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FeatureValidationResponseBaseInner>> checkFeatureSupport(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @BodyParam(value="application/json") FeatureValidationRequestBase var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/locations/{location}/checkFeatureSupport")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<FeatureValidationResponseBaseInner> checkFeatureSupportSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @BodyParam(value="application/json") FeatureValidationRequestBase var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

