/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.models.BaseBackupPolicyResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.BaseBackupPolicy;
import com.azure.resourcemanager.dataprotection.models.BaseBackupPolicyResource;

public final class BaseBackupPolicyResourceImpl
implements BaseBackupPolicyResource,
BaseBackupPolicyResource.Definition,
BaseBackupPolicyResource.Update {
    private BaseBackupPolicyResourceInner innerObject;
    private final DataProtectionManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private String backupPolicyName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public BaseBackupPolicy properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BaseBackupPolicyResourceInner innerModel() {
        return this.innerObject;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BaseBackupPolicyResourceImpl withExistingBackupVault(String resourceGroupName, String vaultName) {
        this.resourceGroupName = resourceGroupName;
        this.vaultName = vaultName;
        return this;
    }

    @Override
    public BaseBackupPolicyResource create() {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public BaseBackupPolicyResource create(Context context) {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    BaseBackupPolicyResourceImpl(String name, DataProtectionManager serviceManager) {
        this.innerObject = new BaseBackupPolicyResourceInner();
        this.serviceManager = serviceManager;
        this.backupPolicyName = name;
    }

    @Override
    public BaseBackupPolicyResourceImpl update() {
        return this;
    }

    @Override
    public BaseBackupPolicyResource apply() {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public BaseBackupPolicyResource apply(Context context) {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().createOrUpdateWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, this.innerModel(), context).getValue());
        return this;
    }

    BaseBackupPolicyResourceImpl(BaseBackupPolicyResourceInner innerObject, DataProtectionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
        this.backupPolicyName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupPolicies");
    }

    @Override
    public BaseBackupPolicyResource refresh() {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().getWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BaseBackupPolicyResource refresh(Context context) {
        this.innerObject = (BaseBackupPolicyResourceInner)((Object)this.serviceManager.serviceClient().getBackupPolicies().getWithResponse(this.resourceGroupName, this.vaultName, this.backupPolicyName, context).getValue());
        return this;
    }

    @Override
    public BaseBackupPolicyResourceImpl withProperties(BaseBackupPolicy properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

