/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dataprotection.DataProtectionManager;
import com.azure.resourcemanager.dataprotection.fluent.models.BackupInstanceResourceInner;
import com.azure.resourcemanager.dataprotection.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRehydrationRequest;
import com.azure.resourcemanager.dataprotection.models.AzureBackupRestoreRequest;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import com.azure.resourcemanager.dataprotection.models.BackupInstanceResource;
import com.azure.resourcemanager.dataprotection.models.OperationJobExtendedInfo;
import com.azure.resourcemanager.dataprotection.models.StopProtectionRequest;
import com.azure.resourcemanager.dataprotection.models.SuspendBackupRequest;
import com.azure.resourcemanager.dataprotection.models.SyncBackupInstanceRequest;
import com.azure.resourcemanager.dataprotection.models.TriggerBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateForModifyBackupRequest;
import com.azure.resourcemanager.dataprotection.models.ValidateRestoreRequestObject;
import java.util.Collections;
import java.util.Map;

public final class BackupInstanceResourceImpl
implements BackupInstanceResource,
BackupInstanceResource.Definition,
BackupInstanceResource.Update {
    private BackupInstanceResourceInner innerObject;
    private final DataProtectionManager serviceManager;
    private String resourceGroupName;
    private String vaultName;
    private String backupInstanceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public BackupInstance properties() {
        return this.innerModel().properties();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public BackupInstanceResourceInner innerModel() {
        return this.innerObject;
    }

    private DataProtectionManager manager() {
        return this.serviceManager;
    }

    @Override
    public BackupInstanceResourceImpl withExistingBackupVault(String resourceGroupName, String vaultName) {
        this.resourceGroupName = resourceGroupName;
        this.vaultName = vaultName;
        return this;
    }

    @Override
    public BackupInstanceResource create() {
        this.innerObject = this.serviceManager.serviceClient().getBackupInstances().createOrUpdate(this.resourceGroupName, this.vaultName, this.backupInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BackupInstanceResource create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupInstances().createOrUpdate(this.resourceGroupName, this.vaultName, this.backupInstanceName, this.innerModel(), context);
        return this;
    }

    BackupInstanceResourceImpl(String name, DataProtectionManager serviceManager) {
        this.innerObject = new BackupInstanceResourceInner();
        this.serviceManager = serviceManager;
        this.backupInstanceName = name;
    }

    @Override
    public BackupInstanceResourceImpl update() {
        return this;
    }

    @Override
    public BackupInstanceResource apply() {
        this.innerObject = this.serviceManager.serviceClient().getBackupInstances().createOrUpdate(this.resourceGroupName, this.vaultName, this.backupInstanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public BackupInstanceResource apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getBackupInstances().createOrUpdate(this.resourceGroupName, this.vaultName, this.backupInstanceName, this.innerModel(), context);
        return this;
    }

    BackupInstanceResourceImpl(BackupInstanceResourceInner innerObject, DataProtectionManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.vaultName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupVaults");
        this.backupInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "backupInstances");
    }

    @Override
    public BackupInstanceResource refresh() {
        this.innerObject = (BackupInstanceResourceInner)((Object)this.serviceManager.serviceClient().getBackupInstances().getWithResponse(this.resourceGroupName, this.vaultName, this.backupInstanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public BackupInstanceResource refresh(Context context) {
        this.innerObject = (BackupInstanceResourceInner)((Object)this.serviceManager.serviceClient().getBackupInstances().getWithResponse(this.resourceGroupName, this.vaultName, this.backupInstanceName, context).getValue());
        return this;
    }

    @Override
    public OperationJobExtendedInfo adhocBackup(TriggerBackupRequest parameters) {
        return this.serviceManager.backupInstances().adhocBackup(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public OperationJobExtendedInfo adhocBackup(TriggerBackupRequest parameters, Context context) {
        return this.serviceManager.backupInstances().adhocBackup(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public OperationJobExtendedInfo validateForModifyBackup(ValidateForModifyBackupRequest parameters) {
        return this.serviceManager.backupInstances().validateForModifyBackup(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public OperationJobExtendedInfo validateForModifyBackup(ValidateForModifyBackupRequest parameters, Context context) {
        return this.serviceManager.backupInstances().validateForModifyBackup(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public void triggerRehydrate(AzureBackupRehydrationRequest parameters) {
        this.serviceManager.backupInstances().triggerRehydrate(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public void triggerRehydrate(AzureBackupRehydrationRequest parameters, Context context) {
        this.serviceManager.backupInstances().triggerRehydrate(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public OperationJobExtendedInfo triggerRestore(AzureBackupRestoreRequest parameters) {
        return this.serviceManager.backupInstances().triggerRestore(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public OperationJobExtendedInfo triggerRestore(AzureBackupRestoreRequest parameters, Context context) {
        return this.serviceManager.backupInstances().triggerRestore(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public void resumeBackups() {
        this.serviceManager.backupInstances().resumeBackups(this.resourceGroupName, this.vaultName, this.backupInstanceName);
    }

    @Override
    public void resumeBackups(Context context) {
        this.serviceManager.backupInstances().resumeBackups(this.resourceGroupName, this.vaultName, this.backupInstanceName, context);
    }

    @Override
    public void resumeProtection() {
        this.serviceManager.backupInstances().resumeProtection(this.resourceGroupName, this.vaultName, this.backupInstanceName);
    }

    @Override
    public void resumeProtection(Context context) {
        this.serviceManager.backupInstances().resumeProtection(this.resourceGroupName, this.vaultName, this.backupInstanceName, context);
    }

    @Override
    public void stopProtection() {
        this.serviceManager.backupInstances().stopProtection(this.resourceGroupName, this.vaultName, this.backupInstanceName);
    }

    @Override
    public void stopProtection(StopProtectionRequest parameters, Context context) {
        this.serviceManager.backupInstances().stopProtection(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public void suspendBackups() {
        this.serviceManager.backupInstances().suspendBackups(this.resourceGroupName, this.vaultName, this.backupInstanceName);
    }

    @Override
    public void suspendBackups(SuspendBackupRequest parameters, Context context) {
        this.serviceManager.backupInstances().suspendBackups(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public void syncBackupInstance(SyncBackupInstanceRequest parameters) {
        this.serviceManager.backupInstances().syncBackupInstance(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public void syncBackupInstance(SyncBackupInstanceRequest parameters, Context context) {
        this.serviceManager.backupInstances().syncBackupInstance(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public OperationJobExtendedInfo validateForRestore(ValidateRestoreRequestObject parameters) {
        return this.serviceManager.backupInstances().validateForRestore(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters);
    }

    @Override
    public OperationJobExtendedInfo validateForRestore(ValidateRestoreRequestObject parameters, Context context) {
        return this.serviceManager.backupInstances().validateForRestore(this.resourceGroupName, this.vaultName, this.backupInstanceName, parameters, context);
    }

    @Override
    public BackupInstanceResourceImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public BackupInstanceResourceImpl withProperties(BackupInstance properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

