/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dataprotection.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dataprotection.models.BackupInstance;
import com.azure.resourcemanager.dataprotection.models.DppProxyResource;
import java.io.IOException;
import java.util.Map;

public final class BackupInstanceResourceInner
extends DppProxyResource {
    private BackupInstance properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public BackupInstance properties() {
        return this.properties;
    }

    public BackupInstanceResourceInner withProperties(BackupInstance properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public BackupInstanceResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static BackupInstanceResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupInstanceResourceInner)((Object)jsonReader.readObject(reader -> {
            BackupInstanceResourceInner deserializedBackupInstanceResourceInner = new BackupInstanceResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBackupInstanceResourceInner.withTags(tags);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupInstanceResourceInner.properties = BackupInstance.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupInstanceResourceInner;
        }));
    }
}

