/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlBackupFileInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.UUID;

public final class SqlBackupSetInfo
implements JsonSerializable<SqlBackupSetInfo> {
    private UUID backupSetId;
    private String firstLsn;
    private String lastLsn;
    private String backupType;
    private List<SqlBackupFileInfo> listOfBackupFiles;
    private OffsetDateTime backupStartDate;
    private OffsetDateTime backupFinishDate;
    private Boolean isBackupRestored;
    private Boolean hasBackupChecksums;
    private Integer familyCount;
    private List<String> ignoreReasons;

    public UUID backupSetId() {
        return this.backupSetId;
    }

    public String firstLsn() {
        return this.firstLsn;
    }

    public String lastLsn() {
        return this.lastLsn;
    }

    public String backupType() {
        return this.backupType;
    }

    public List<SqlBackupFileInfo> listOfBackupFiles() {
        return this.listOfBackupFiles;
    }

    public OffsetDateTime backupStartDate() {
        return this.backupStartDate;
    }

    public OffsetDateTime backupFinishDate() {
        return this.backupFinishDate;
    }

    public Boolean isBackupRestored() {
        return this.isBackupRestored;
    }

    public Boolean hasBackupChecksums() {
        return this.hasBackupChecksums;
    }

    public Integer familyCount() {
        return this.familyCount;
    }

    public List<String> ignoreReasons() {
        return this.ignoreReasons;
    }

    public void validate() {
        if (this.listOfBackupFiles() != null) {
            this.listOfBackupFiles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SqlBackupSetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (SqlBackupSetInfo)jsonReader.readObject(reader -> {
            SqlBackupSetInfo deserializedSqlBackupSetInfo = new SqlBackupSetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupSetId".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.backupSetId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("firstLSN".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.firstLsn = reader.getString();
                    continue;
                }
                if ("lastLSN".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.lastLsn = reader.getString();
                    continue;
                }
                if ("backupType".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.backupType = reader.getString();
                    continue;
                }
                if ("listOfBackupFiles".equals(fieldName)) {
                    List listOfBackupFiles;
                    deserializedSqlBackupSetInfo.listOfBackupFiles = listOfBackupFiles = reader.readArray(reader1 -> SqlBackupFileInfo.fromJson(reader1));
                    continue;
                }
                if ("backupStartDate".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.backupStartDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupFinishDate".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.backupFinishDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isBackupRestored".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.isBackupRestored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hasBackupChecksums".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.hasBackupChecksums = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("familyCount".equals(fieldName)) {
                    deserializedSqlBackupSetInfo.familyCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("ignoreReasons".equals(fieldName)) {
                    List ignoreReasons;
                    deserializedSqlBackupSetInfo.ignoreReasons = ignoreReasons = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlBackupSetInfo;
        });
    }
}

