/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.QuotaInner;
import java.io.IOException;
import java.util.List;

public final class QuotaList
implements JsonSerializable<QuotaList> {
    private List<QuotaInner> value;
    private String nextLink;

    public List<QuotaInner> value() {
        return this.value;
    }

    public QuotaList withValue(List<QuotaInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public QuotaList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static QuotaList fromJson(JsonReader jsonReader) throws IOException {
        return (QuotaList)jsonReader.readObject(reader -> {
            QuotaList deserializedQuotaList = new QuotaList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedQuotaList.value = value = reader.readArray(reader1 -> QuotaInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedQuotaList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQuotaList;
        });
    }
}

