/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DataIntegrityValidationResult;
import com.azure.resourcemanager.datamigration.models.QueryAnalysisValidationResult;
import com.azure.resourcemanager.datamigration.models.SchemaComparisonValidationResult;
import com.azure.resourcemanager.datamigration.models.ValidationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public class MigrationValidationDatabaseLevelResult
implements JsonSerializable<MigrationValidationDatabaseLevelResult> {
    private String id;
    private String migrationId;
    private String sourceDatabaseName;
    private String targetDatabaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private DataIntegrityValidationResult dataIntegrityValidationResult;
    private SchemaComparisonValidationResult schemaValidationResult;
    private QueryAnalysisValidationResult queryAnalysisValidationResult;
    private ValidationStatus status;

    public String id() {
        return this.id;
    }

    MigrationValidationDatabaseLevelResult withId(String id) {
        this.id = id;
        return this;
    }

    public String migrationId() {
        return this.migrationId;
    }

    MigrationValidationDatabaseLevelResult withMigrationId(String migrationId) {
        this.migrationId = migrationId;
        return this;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    MigrationValidationDatabaseLevelResult withSourceDatabaseName(String sourceDatabaseName) {
        this.sourceDatabaseName = sourceDatabaseName;
        return this;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    MigrationValidationDatabaseLevelResult withTargetDatabaseName(String targetDatabaseName) {
        this.targetDatabaseName = targetDatabaseName;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    MigrationValidationDatabaseLevelResult withStartedOn(OffsetDateTime startedOn) {
        this.startedOn = startedOn;
        return this;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    MigrationValidationDatabaseLevelResult withEndedOn(OffsetDateTime endedOn) {
        this.endedOn = endedOn;
        return this;
    }

    public DataIntegrityValidationResult dataIntegrityValidationResult() {
        return this.dataIntegrityValidationResult;
    }

    MigrationValidationDatabaseLevelResult withDataIntegrityValidationResult(DataIntegrityValidationResult dataIntegrityValidationResult) {
        this.dataIntegrityValidationResult = dataIntegrityValidationResult;
        return this;
    }

    public SchemaComparisonValidationResult schemaValidationResult() {
        return this.schemaValidationResult;
    }

    MigrationValidationDatabaseLevelResult withSchemaValidationResult(SchemaComparisonValidationResult schemaValidationResult) {
        this.schemaValidationResult = schemaValidationResult;
        return this;
    }

    public QueryAnalysisValidationResult queryAnalysisValidationResult() {
        return this.queryAnalysisValidationResult;
    }

    MigrationValidationDatabaseLevelResult withQueryAnalysisValidationResult(QueryAnalysisValidationResult queryAnalysisValidationResult) {
        this.queryAnalysisValidationResult = queryAnalysisValidationResult;
        return this;
    }

    public ValidationStatus status() {
        return this.status;
    }

    MigrationValidationDatabaseLevelResult withStatus(ValidationStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.dataIntegrityValidationResult() != null) {
            this.dataIntegrityValidationResult().validate();
        }
        if (this.schemaValidationResult() != null) {
            this.schemaValidationResult().validate();
        }
        if (this.queryAnalysisValidationResult() != null) {
            this.queryAnalysisValidationResult().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static MigrationValidationDatabaseLevelResult fromJson(JsonReader jsonReader) throws IOException {
        return (MigrationValidationDatabaseLevelResult)jsonReader.readObject(reader -> {
            MigrationValidationDatabaseLevelResult deserializedMigrationValidationDatabaseLevelResult = new MigrationValidationDatabaseLevelResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.id = reader.getString();
                    continue;
                }
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.migrationId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("targetDatabaseName".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.targetDatabaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dataIntegrityValidationResult".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.dataIntegrityValidationResult = DataIntegrityValidationResult.fromJson(reader);
                    continue;
                }
                if ("schemaValidationResult".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.schemaValidationResult = SchemaComparisonValidationResult.fromJson(reader);
                    continue;
                }
                if ("queryAnalysisValidationResult".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.queryAnalysisValidationResult = QueryAnalysisValidationResult.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrationValidationDatabaseLevelResult.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrationValidationDatabaseLevelResult;
        });
    }
}

