/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.MigrationStatus;
import com.azure.resourcemanager.datamigration.models.OrphanedUserInfo;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlMITaskOutputMigrationLevel
extends MigrateSqlServerSqlMITaskOutput {
    private String resultType = "MigrationLevelOutput";
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private MigrationStatus status;
    private MigrationState state;
    private String agentJobs;
    private String logins;
    private String message;
    private String serverRoleResults;
    private List<OrphanedUserInfo> orphanedUsersInfo;
    private String databases;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private String targetServerVersion;
    private String targetServerBrandVersion;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public MigrationStatus status() {
        return this.status;
    }

    public MigrationState state() {
        return this.state;
    }

    public String agentJobs() {
        return this.agentJobs;
    }

    public String logins() {
        return this.logins;
    }

    public String message() {
        return this.message;
    }

    public String serverRoleResults() {
        return this.serverRoleResults;
    }

    public List<OrphanedUserInfo> orphanedUsersInfo() {
        return this.orphanedUsersInfo;
    }

    public String databases() {
        return this.databases;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public String targetServerVersion() {
        return this.targetServerVersion;
    }

    public String targetServerBrandVersion() {
        return this.targetServerBrandVersion;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.orphanedUsersInfo() != null) {
            this.orphanedUsersInfo().forEach(e -> e.validate());
        }
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskOutputMigrationLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskOutputMigrationLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskOutputMigrationLevel deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel = new MigrateSqlServerSqlMITaskOutputMigrationLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.resultType = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.status = MigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("agentJobs".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.agentJobs = reader.getString();
                    continue;
                }
                if ("logins".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.logins = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.message = reader.getString();
                    continue;
                }
                if ("serverRoleResults".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.serverRoleResults = reader.getString();
                    continue;
                }
                if ("orphanedUsersInfo".equals(fieldName)) {
                    List orphanedUsersInfo;
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.orphanedUsersInfo = orphanedUsersInfo = reader.readArray(reader1 -> OrphanedUserInfo.fromJson(reader1));
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.databases = reader.getString();
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("targetServerVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.targetServerVersion = reader.getString();
                    continue;
                }
                if ("targetServerBrandVersion".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.targetServerBrandVersion = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskOutputMigrationLevel;
        });
    }
}

