/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationStage;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlMITaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSqlServerSqlMITaskOutputDatabaseLevel
extends MigrateSqlServerSqlMITaskOutput {
    private String resultType = "DatabaseLevelOutput";
    private String databaseName;
    private Double sizeMB;
    private MigrationState state;
    private DatabaseMigrationStage stage;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String message;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public Double sizeMB() {
        return this.sizeMB;
    }

    public MigrationState state() {
        return this.state;
    }

    public DatabaseMigrationStage stage() {
        return this.stage;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String message() {
        return this.message;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlMITaskOutputDatabaseLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlMITaskOutputDatabaseLevel)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlMITaskOutputDatabaseLevel deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel = new MigrateSqlServerSqlMITaskOutputDatabaseLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.resultType = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.databaseName = reader.getString();
                    continue;
                }
                if ("sizeMB".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.sizeMB = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.stage = DatabaseMigrationStage.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.message = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlMITaskOutputDatabaseLevel;
        });
    }
}

