/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationValidationDatabaseSummaryResult;
import com.azure.resourcemanager.datamigration.models.ValidationStatus;
import java.io.IOException;
import java.util.Map;

public final class MigrateSqlServerSqlDbTaskOutputValidationResult
extends MigrateSqlServerSqlDbTaskOutput {
    private String resultType = "MigrationValidationOutput";
    private String id;
    private String migrationId;
    private Map<String, MigrationValidationDatabaseSummaryResult> summaryResults;
    private ValidationStatus status;

    @Override
    public String resultType() {
        return this.resultType;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String migrationId() {
        return this.migrationId;
    }

    public Map<String, MigrationValidationDatabaseSummaryResult> summaryResults() {
        return this.summaryResults;
    }

    public MigrateSqlServerSqlDbTaskOutputValidationResult withSummaryResults(Map<String, MigrationValidationDatabaseSummaryResult> summaryResults) {
        this.summaryResults = summaryResults;
        return this;
    }

    public ValidationStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.summaryResults() != null) {
            this.summaryResults().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        jsonWriter.writeMapField("summaryResults", this.summaryResults, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskOutputValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskOutputValidationResult)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskOutputValidationResult deserializedMigrateSqlServerSqlDbTaskOutputValidationResult = new MigrateSqlServerSqlDbTaskOutputValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputValidationResult.resultType = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputValidationResult.id = reader.getString();
                    continue;
                }
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputValidationResult.migrationId = reader.getString();
                    continue;
                }
                if ("summaryResults".equals(fieldName)) {
                    Map summaryResults;
                    deserializedMigrateSqlServerSqlDbTaskOutputValidationResult.summaryResults = summaryResults = reader.readMap(reader1 -> MigrationValidationDatabaseSummaryResult.fromJson(reader1));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputValidationResult.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskOutputValidationResult;
        });
    }
}

