/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DataIntegrityValidationResult;
import com.azure.resourcemanager.datamigration.models.MigrateSqlServerSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.QueryAnalysisValidationResult;
import com.azure.resourcemanager.datamigration.models.SchemaComparisonValidationResult;
import com.azure.resourcemanager.datamigration.models.ValidationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult
extends MigrateSqlServerSqlDbTaskOutput {
    private String resultType = "MigrationDatabaseLevelValidationOutput";
    private String id;
    private String migrationId;
    private String sourceDatabaseName;
    private String targetDatabaseName;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private DataIntegrityValidationResult dataIntegrityValidationResult;
    private SchemaComparisonValidationResult schemaValidationResult;
    private QueryAnalysisValidationResult queryAnalysisValidationResult;
    private ValidationStatus status;

    @Override
    public String resultType() {
        return this.resultType;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String migrationId() {
        return this.migrationId;
    }

    public String sourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public DataIntegrityValidationResult dataIntegrityValidationResult() {
        return this.dataIntegrityValidationResult;
    }

    public SchemaComparisonValidationResult schemaValidationResult() {
        return this.schemaValidationResult;
    }

    public QueryAnalysisValidationResult queryAnalysisValidationResult() {
        return this.queryAnalysisValidationResult;
    }

    public ValidationStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
        if (this.dataIntegrityValidationResult() != null) {
            this.dataIntegrityValidationResult().validate();
        }
        if (this.schemaValidationResult() != null) {
            this.schemaValidationResult().validate();
        }
        if (this.queryAnalysisValidationResult() != null) {
            this.queryAnalysisValidationResult().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult)jsonReader.readObject(reader -> {
            MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult = new MigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.resultType = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.id = reader.getString();
                    continue;
                }
                if ("migrationId".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.migrationId = reader.getString();
                    continue;
                }
                if ("sourceDatabaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.sourceDatabaseName = reader.getString();
                    continue;
                }
                if ("targetDatabaseName".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.targetDatabaseName = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dataIntegrityValidationResult".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.dataIntegrityValidationResult = DataIntegrityValidationResult.fromJson(reader);
                    continue;
                }
                if ("schemaValidationResult".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.schemaValidationResult = SchemaComparisonValidationResult.fromJson(reader);
                    continue;
                }
                if ("queryAnalysisValidationResult".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.queryAnalysisValidationResult = QueryAnalysisValidationResult.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult.status = ValidationStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSqlServerSqlDbTaskOutputDatabaseLevelValidationResult;
        });
    }
}

