/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.CommandState;
import com.azure.resourcemanager.datamigration.models.CommandType;
import com.azure.resourcemanager.datamigration.models.MigrateMISyncCompleteCommandInput;
import com.azure.resourcemanager.datamigration.models.MigrateMISyncCompleteCommandOutput;
import java.io.IOException;
import java.util.List;

public final class MigrateMISyncCompleteCommandProperties
extends CommandPropertiesInner {
    private CommandType commandType = CommandType.MIGRATE_SQL_SERVER_AZURE_DB_SQL_MI_COMPLETE;
    private MigrateMISyncCompleteCommandInput input;
    private MigrateMISyncCompleteCommandOutput output;
    private CommandState state;
    private List<ManagementError> errors;

    @Override
    public CommandType commandType() {
        return this.commandType;
    }

    public MigrateMISyncCompleteCommandInput input() {
        return this.input;
    }

    public MigrateMISyncCompleteCommandProperties withInput(MigrateMISyncCompleteCommandInput input) {
        this.input = input;
        return this;
    }

    public MigrateMISyncCompleteCommandOutput output() {
        return this.output;
    }

    @Override
    public CommandState state() {
        return this.state;
    }

    @Override
    public List<ManagementError> errors() {
        return this.errors;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandType", this.commandType == null ? null : this.commandType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static MigrateMISyncCompleteCommandProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateMISyncCompleteCommandProperties)jsonReader.readObject(reader -> {
            MigrateMISyncCompleteCommandProperties deserializedMigrateMISyncCompleteCommandProperties = new MigrateMISyncCompleteCommandProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedMigrateMISyncCompleteCommandProperties.errors = errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateMISyncCompleteCommandProperties.state = CommandState.fromString(reader.getString());
                    continue;
                }
                if ("commandType".equals(fieldName)) {
                    deserializedMigrateMISyncCompleteCommandProperties.commandType = CommandType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedMigrateMISyncCompleteCommandProperties.input = MigrateMISyncCompleteCommandInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    deserializedMigrateMISyncCompleteCommandProperties.output = MigrateMISyncCompleteCommandOutput.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateMISyncCompleteCommandProperties;
        });
    }
}

