/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MySqlConnectionInfo;
import java.io.IOException;

public final class ConnectToTargetAzureDbForMySqlTaskInput
implements JsonSerializable<ConnectToTargetAzureDbForMySqlTaskInput> {
    private MySqlConnectionInfo sourceConnectionInfo;
    private MySqlConnectionInfo targetConnectionInfo;
    private Boolean isOfflineMigration;
    private static final ClientLogger LOGGER = new ClientLogger(ConnectToTargetAzureDbForMySqlTaskInput.class);

    public MySqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public ConnectToTargetAzureDbForMySqlTaskInput withSourceConnectionInfo(MySqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public MySqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public ConnectToTargetAzureDbForMySqlTaskInput withTargetConnectionInfo(MySqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public Boolean isOfflineMigration() {
        return this.isOfflineMigration;
    }

    public ConnectToTargetAzureDbForMySqlTaskInput withIsOfflineMigration(Boolean isOfflineMigration) {
        this.isOfflineMigration = isOfflineMigration;
        return this;
    }

    public void validate() {
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model ConnectToTargetAzureDbForMySqlTaskInput"));
        }
        this.sourceConnectionInfo().validate();
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model ConnectToTargetAzureDbForMySqlTaskInput"));
        }
        this.targetConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeBooleanField("isOfflineMigration", this.isOfflineMigration);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetAzureDbForMySqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetAzureDbForMySqlTaskInput)jsonReader.readObject(reader -> {
            ConnectToTargetAzureDbForMySqlTaskInput deserializedConnectToTargetAzureDbForMySqlTaskInput = new ConnectToTargetAzureDbForMySqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetAzureDbForMySqlTaskInput.sourceConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedConnectToTargetAzureDbForMySqlTaskInput.targetConnectionInfo = MySqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("isOfflineMigration".equals(fieldName)) {
                    deserializedConnectToTargetAzureDbForMySqlTaskInput.isOfflineMigration = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetAzureDbForMySqlTaskInput;
        });
    }
}

