/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ConnectToSourceSqlServerTaskOutput;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class ConnectToSourceSqlServerTaskOutputTaskLevel
extends ConnectToSourceSqlServerTaskOutput {
    private String resultType = "TaskLevelOutput";
    private String databases;
    private String logins;
    private String agentJobs;
    private String databaseTdeCertificateMapping;
    private String sourceServerVersion;
    private String sourceServerBrandVersion;
    private List<ReportableException> validationErrors;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String databases() {
        return this.databases;
    }

    public String logins() {
        return this.logins;
    }

    public String agentJobs() {
        return this.agentJobs;
    }

    public String databaseTdeCertificateMapping() {
        return this.databaseTdeCertificateMapping;
    }

    public String sourceServerVersion() {
        return this.sourceServerVersion;
    }

    public String sourceServerBrandVersion() {
        return this.sourceServerBrandVersion;
    }

    public List<ReportableException> validationErrors() {
        return this.validationErrors;
    }

    @Override
    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToSourceSqlServerTaskOutputTaskLevel fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToSourceSqlServerTaskOutputTaskLevel)jsonReader.readObject(reader -> {
            ConnectToSourceSqlServerTaskOutputTaskLevel deserializedConnectToSourceSqlServerTaskOutputTaskLevel = new ConnectToSourceSqlServerTaskOutputTaskLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.resultType = reader.getString();
                    continue;
                }
                if ("databases".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.databases = reader.getString();
                    continue;
                }
                if ("logins".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.logins = reader.getString();
                    continue;
                }
                if ("agentJobs".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.agentJobs = reader.getString();
                    continue;
                }
                if ("databaseTdeCertificateMapping".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.databaseTdeCertificateMapping = reader.getString();
                    continue;
                }
                if ("sourceServerVersion".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.sourceServerVersion = reader.getString();
                    continue;
                }
                if ("sourceServerBrandVersion".equals(fieldName)) {
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.sourceServerBrandVersion = reader.getString();
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    List validationErrors;
                    deserializedConnectToSourceSqlServerTaskOutputTaskLevel.validationErrors = validationErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToSourceSqlServerTaskOutputTaskLevel;
        });
    }
}

