/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.BackupFileInfo;
import com.azure.resourcemanager.datamigration.models.BackupType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class BackupSetInfo
implements JsonSerializable<BackupSetInfo> {
    private String backupSetId;
    private String firstLsn;
    private String lastLsn;
    private OffsetDateTime lastModifiedTime;
    private BackupType backupType;
    private List<BackupFileInfo> listOfBackupFiles;
    private String databaseName;
    private OffsetDateTime backupStartDate;
    private OffsetDateTime backupFinishedDate;
    private Boolean isBackupRestored;

    public String backupSetId() {
        return this.backupSetId;
    }

    public BackupSetInfo withBackupSetId(String backupSetId) {
        this.backupSetId = backupSetId;
        return this;
    }

    public String firstLsn() {
        return this.firstLsn;
    }

    public BackupSetInfo withFirstLsn(String firstLsn) {
        this.firstLsn = firstLsn;
        return this;
    }

    public String lastLsn() {
        return this.lastLsn;
    }

    public BackupSetInfo withLastLsn(String lastLsn) {
        this.lastLsn = lastLsn;
        return this;
    }

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public BackupSetInfo withLastModifiedTime(OffsetDateTime lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
        return this;
    }

    public BackupType backupType() {
        return this.backupType;
    }

    public BackupSetInfo withBackupType(BackupType backupType) {
        this.backupType = backupType;
        return this;
    }

    public List<BackupFileInfo> listOfBackupFiles() {
        return this.listOfBackupFiles;
    }

    public BackupSetInfo withListOfBackupFiles(List<BackupFileInfo> listOfBackupFiles) {
        this.listOfBackupFiles = listOfBackupFiles;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public BackupSetInfo withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public OffsetDateTime backupStartDate() {
        return this.backupStartDate;
    }

    public BackupSetInfo withBackupStartDate(OffsetDateTime backupStartDate) {
        this.backupStartDate = backupStartDate;
        return this;
    }

    public OffsetDateTime backupFinishedDate() {
        return this.backupFinishedDate;
    }

    public BackupSetInfo withBackupFinishedDate(OffsetDateTime backupFinishedDate) {
        this.backupFinishedDate = backupFinishedDate;
        return this;
    }

    public Boolean isBackupRestored() {
        return this.isBackupRestored;
    }

    public BackupSetInfo withIsBackupRestored(Boolean isBackupRestored) {
        this.isBackupRestored = isBackupRestored;
        return this;
    }

    public void validate() {
        if (this.listOfBackupFiles() != null) {
            this.listOfBackupFiles().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("backupSetId", this.backupSetId);
        jsonWriter.writeStringField("firstLsn", this.firstLsn);
        jsonWriter.writeStringField("lastLsn", this.lastLsn);
        jsonWriter.writeStringField("lastModifiedTime", this.lastModifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedTime));
        jsonWriter.writeStringField("backupType", this.backupType == null ? null : this.backupType.toString());
        jsonWriter.writeArrayField("listOfBackupFiles", this.listOfBackupFiles, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeStringField("backupStartDate", this.backupStartDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.backupStartDate));
        jsonWriter.writeStringField("backupFinishedDate", this.backupFinishedDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.backupFinishedDate));
        jsonWriter.writeBooleanField("isBackupRestored", this.isBackupRestored);
        return jsonWriter.writeEndObject();
    }

    public static BackupSetInfo fromJson(JsonReader jsonReader) throws IOException {
        return (BackupSetInfo)jsonReader.readObject(reader -> {
            BackupSetInfo deserializedBackupSetInfo = new BackupSetInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupSetId".equals(fieldName)) {
                    deserializedBackupSetInfo.backupSetId = reader.getString();
                    continue;
                }
                if ("firstLsn".equals(fieldName)) {
                    deserializedBackupSetInfo.firstLsn = reader.getString();
                    continue;
                }
                if ("lastLsn".equals(fieldName)) {
                    deserializedBackupSetInfo.lastLsn = reader.getString();
                    continue;
                }
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedBackupSetInfo.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupType".equals(fieldName)) {
                    deserializedBackupSetInfo.backupType = BackupType.fromString(reader.getString());
                    continue;
                }
                if ("listOfBackupFiles".equals(fieldName)) {
                    List listOfBackupFiles;
                    deserializedBackupSetInfo.listOfBackupFiles = listOfBackupFiles = reader.readArray(reader1 -> BackupFileInfo.fromJson(reader1));
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedBackupSetInfo.databaseName = reader.getString();
                    continue;
                }
                if ("backupStartDate".equals(fieldName)) {
                    deserializedBackupSetInfo.backupStartDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("backupFinishedDate".equals(fieldName)) {
                    deserializedBackupSetInfo.backupFinishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isBackupRestored".equals(fieldName)) {
                    deserializedBackupSetInfo.isBackupRestored = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupSetInfo;
        });
    }
}

