/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlVmInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlVm;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlVm;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.util.UUID;

public final class DatabaseMigrationSqlVmImpl
implements DatabaseMigrationSqlVm,
DatabaseMigrationSqlVm.Definition,
DatabaseMigrationSqlVm.Update {
    private DatabaseMigrationSqlVmInner innerObject;
    private final DataMigrationManager serviceManager;
    private String resourceGroupName;
    private String sqlVirtualMachineName;
    private String targetDbName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DatabaseMigrationPropertiesSqlVm properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DatabaseMigrationSqlVmInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlVmImpl withExistingSqlVirtualMachine(String resourceGroupName, String sqlVirtualMachineName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlVirtualMachineName = sqlVirtualMachineName;
        return this;
    }

    @Override
    public DatabaseMigrationSqlVm create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().createOrUpdate(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlVm create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().createOrUpdate(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlVmImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new DatabaseMigrationSqlVmInner();
        this.serviceManager = serviceManager;
        this.targetDbName = name;
    }

    @Override
    public DatabaseMigrationSqlVmImpl update() {
        return this;
    }

    @Override
    public DatabaseMigrationSqlVm apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().createOrUpdate(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlVm apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().createOrUpdate(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlVmImpl(DatabaseMigrationSqlVmInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.sqlVirtualMachineName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "sqlVirtualMachines");
        this.targetDbName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databaseMigrations");
    }

    @Override
    public DatabaseMigrationSqlVm refresh() {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlVmInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().getWithResponse(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatabaseMigrationSqlVm refresh(Context context) {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlVmInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlVms().getWithResponse(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, localMigrationOperationId, localExpand, context).getValue());
        return this;
    }

    @Override
    public void cancel(MigrationOperationInput parameters) {
        this.serviceManager.databaseMigrationsSqlVms().cancel(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, parameters);
    }

    @Override
    public void cancel(MigrationOperationInput parameters, Context context) {
        this.serviceManager.databaseMigrationsSqlVms().cancel(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, parameters, context);
    }

    @Override
    public void cutover(MigrationOperationInput parameters) {
        this.serviceManager.databaseMigrationsSqlVms().cutover(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, parameters);
    }

    @Override
    public void cutover(MigrationOperationInput parameters, Context context) {
        this.serviceManager.databaseMigrationsSqlVms().cutover(this.resourceGroupName, this.sqlVirtualMachineName, this.targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlVmImpl withProperties(DatabaseMigrationPropertiesSqlVm properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

