/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectProperties;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseInfo;
import com.azure.resourcemanager.datamigration.models.ProjectProvisioningState;
import com.azure.resourcemanager.datamigration.models.ProjectSourcePlatform;
import com.azure.resourcemanager.datamigration.models.ProjectTargetPlatform;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ProjectInner
extends Resource {
    private ProjectProperties innerProperties;
    private String etag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ProjectProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public ProjectInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ProjectInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProjectInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProjectSourcePlatform sourcePlatform() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePlatform();
    }

    public ProjectInner withSourcePlatform(ProjectSourcePlatform sourcePlatform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withSourcePlatform(sourcePlatform);
        return this;
    }

    public AzureActiveDirectoryApp azureAuthenticationInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().azureAuthenticationInfo();
    }

    public ProjectInner withAzureAuthenticationInfo(AzureActiveDirectoryApp azureAuthenticationInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withAzureAuthenticationInfo(azureAuthenticationInfo);
        return this;
    }

    public ProjectTargetPlatform targetPlatform() {
        return this.innerProperties() == null ? null : this.innerProperties().targetPlatform();
    }

    public ProjectInner withTargetPlatform(ProjectTargetPlatform targetPlatform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withTargetPlatform(targetPlatform);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public ConnectionInfo sourceConnectionInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceConnectionInfo();
    }

    public ProjectInner withSourceConnectionInfo(ConnectionInfo sourceConnectionInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withSourceConnectionInfo(sourceConnectionInfo);
        return this;
    }

    public ConnectionInfo targetConnectionInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().targetConnectionInfo();
    }

    public ProjectInner withTargetConnectionInfo(ConnectionInfo targetConnectionInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withTargetConnectionInfo(targetConnectionInfo);
        return this;
    }

    public List<DatabaseInfo> databasesInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().databasesInfo();
    }

    public ProjectInner withDatabasesInfo(List<DatabaseInfo> databasesInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProjectProperties();
        }
        this.innerProperties().withDatabasesInfo(databasesInfo);
        return this;
    }

    public ProjectProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("etag", this.etag);
        return jsonWriter.writeEndObject();
    }

    public static ProjectInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectInner)((Object)jsonReader.readObject(reader -> {
            ProjectInner deserializedProjectInner = new ProjectInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProjectInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProjectInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProjectInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedProjectInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedProjectInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProjectInner.innerProperties = ProjectProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedProjectInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProjectInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectInner;
        }));
    }
}

