/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.CommandState;
import com.azure.resourcemanager.datamigration.models.CommandType;
import com.azure.resourcemanager.datamigration.models.MigrateMISyncCompleteCommandProperties;
import com.azure.resourcemanager.datamigration.models.MigrateSyncCompleteCommandProperties;
import com.azure.resourcemanager.datamigration.models.MongoDbCancelCommand;
import com.azure.resourcemanager.datamigration.models.MongoDbFinishCommand;
import com.azure.resourcemanager.datamigration.models.MongoDbRestartCommand;
import java.io.IOException;
import java.util.List;

public class CommandPropertiesInner
implements JsonSerializable<CommandPropertiesInner> {
    private CommandType commandType = CommandType.fromString("CommandProperties");
    private List<ManagementError> errors;
    private CommandState state;

    public CommandType commandType() {
        return this.commandType;
    }

    public List<ManagementError> errors() {
        return this.errors;
    }

    CommandPropertiesInner withErrors(List<ManagementError> errors) {
        this.errors = errors;
        return this;
    }

    public CommandState state() {
        return this.state;
    }

    CommandPropertiesInner withState(CommandState state) {
        this.state = state;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandType", this.commandType == null ? null : this.commandType.toString());
        return jsonWriter.writeEndObject();
    }

    public static CommandPropertiesInner fromJson(JsonReader jsonReader) throws IOException {
        return (CommandPropertiesInner)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CommandPropertiesInner commandPropertiesInner;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("commandType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Migrate.Sync.Complete.Database".equals(discriminatorValue)) {
                    commandPropertiesInner = MigrateSyncCompleteCommandProperties.fromJson(readerToUse.reset());
                    return commandPropertiesInner;
                }
                if ("Migrate.SqlServer.AzureDbSqlMi.Complete".equals(discriminatorValue)) {
                    commandPropertiesInner = MigrateMISyncCompleteCommandProperties.fromJson(readerToUse.reset());
                    return commandPropertiesInner;
                }
                if ("cancel".equals(discriminatorValue)) {
                    commandPropertiesInner = MongoDbCancelCommand.fromJson(readerToUse.reset());
                    return commandPropertiesInner;
                }
                if ("finish".equals(discriminatorValue)) {
                    commandPropertiesInner = MongoDbFinishCommand.fromJson(readerToUse.reset());
                    return commandPropertiesInner;
                }
                if ("restart".equals(discriminatorValue)) {
                    commandPropertiesInner = MongoDbRestartCommand.fromJson(readerToUse.reset());
                    return commandPropertiesInner;
                }
                commandPropertiesInner = CommandPropertiesInner.fromJsonKnownDiscriminator(readerToUse.reset());
                return commandPropertiesInner;
            }
        });
    }

    static CommandPropertiesInner fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (CommandPropertiesInner)jsonReader.readObject(reader -> {
            CommandPropertiesInner deserializedCommandPropertiesInner = new CommandPropertiesInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandType".equals(fieldName)) {
                    deserializedCommandPropertiesInner.commandType = CommandType.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedCommandPropertiesInner.errors = errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCommandPropertiesInner.state = CommandState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommandPropertiesInner;
        });
    }
}

