/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import com.azure.resourcemanager.datamigration.models.UploadOciDriverTaskInput;
import com.azure.resourcemanager.datamigration.models.UploadOciDriverTaskOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class UploadOciDriverTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.SERVICE_UPLOAD_OCI;
    private UploadOciDriverTaskInput input;
    private List<UploadOciDriverTaskOutput> output;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public UploadOciDriverTaskInput input() {
        return this.input;
    }

    public UploadOciDriverTaskProperties withInput(UploadOciDriverTaskInput input) {
        this.input = input;
        return this;
    }

    public List<UploadOciDriverTaskOutput> output() {
        return this.output;
    }

    @Override
    public UploadOciDriverTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        return jsonWriter.writeEndObject();
    }

    public static UploadOciDriverTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UploadOciDriverTaskProperties)jsonReader.readObject(reader -> {
            UploadOciDriverTaskProperties deserializedUploadOciDriverTaskProperties = new UploadOciDriverTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedUploadOciDriverTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedUploadOciDriverTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedUploadOciDriverTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedUploadOciDriverTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedUploadOciDriverTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedUploadOciDriverTaskProperties.input = UploadOciDriverTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedUploadOciDriverTaskProperties.output = output = reader.readArray(reader1 -> UploadOciDriverTaskOutput.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUploadOciDriverTaskProperties;
        });
    }
}

