/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthenticationType;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import java.io.IOException;

public final class PostgreSqlConnectionInfo
extends ConnectionInfo {
    private String type = "PostgreSqlConnectionInfo";
    private String serverName;
    private String dataSource;
    private String serverVersion;
    private String databaseName;
    private int port;
    private Boolean encryptConnection;
    private Boolean trustServerCertificate;
    private String additionalSettings;
    private String serverBrandVersion;
    private AuthenticationType authentication;
    private static final ClientLogger LOGGER = new ClientLogger(PostgreSqlConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String serverName() {
        return this.serverName;
    }

    public PostgreSqlConnectionInfo withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public PostgreSqlConnectionInfo withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public String serverVersion() {
        return this.serverVersion;
    }

    public PostgreSqlConnectionInfo withServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public PostgreSqlConnectionInfo withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public int port() {
        return this.port;
    }

    public PostgreSqlConnectionInfo withPort(int port) {
        this.port = port;
        return this;
    }

    public Boolean encryptConnection() {
        return this.encryptConnection;
    }

    public PostgreSqlConnectionInfo withEncryptConnection(Boolean encryptConnection) {
        this.encryptConnection = encryptConnection;
        return this;
    }

    public Boolean trustServerCertificate() {
        return this.trustServerCertificate;
    }

    public PostgreSqlConnectionInfo withTrustServerCertificate(Boolean trustServerCertificate) {
        this.trustServerCertificate = trustServerCertificate;
        return this;
    }

    public String additionalSettings() {
        return this.additionalSettings;
    }

    public PostgreSqlConnectionInfo withAdditionalSettings(String additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    public String serverBrandVersion() {
        return this.serverBrandVersion;
    }

    public PostgreSqlConnectionInfo withServerBrandVersion(String serverBrandVersion) {
        this.serverBrandVersion = serverBrandVersion;
        return this;
    }

    public AuthenticationType authentication() {
        return this.authentication;
    }

    public PostgreSqlConnectionInfo withAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
        return this;
    }

    @Override
    public PostgreSqlConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public PostgreSqlConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.serverName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverName in model PostgreSqlConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("serverVersion", this.serverVersion);
        jsonWriter.writeStringField("databaseName", this.databaseName);
        jsonWriter.writeBooleanField("encryptConnection", this.encryptConnection);
        jsonWriter.writeBooleanField("trustServerCertificate", this.trustServerCertificate);
        jsonWriter.writeStringField("additionalSettings", this.additionalSettings);
        jsonWriter.writeStringField("serverBrandVersion", this.serverBrandVersion);
        jsonWriter.writeStringField("authentication", this.authentication == null ? null : this.authentication.toString());
        return jsonWriter.writeEndObject();
    }

    public static PostgreSqlConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (PostgreSqlConnectionInfo)jsonReader.readObject(reader -> {
            PostgreSqlConnectionInfo deserializedPostgreSqlConnectionInfo = new PostgreSqlConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.serverName = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.port = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.dataSource = reader.getString();
                    continue;
                }
                if ("serverVersion".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.serverVersion = reader.getString();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.databaseName = reader.getString();
                    continue;
                }
                if ("encryptConnection".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.encryptConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("trustServerCertificate".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.trustServerCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("additionalSettings".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.additionalSettings = reader.getString();
                    continue;
                }
                if ("serverBrandVersion".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.serverBrandVersion = reader.getString();
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedPostgreSqlConnectionInfo.authentication = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPostgreSqlConnectionInfo;
        });
    }
}

