/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigrateSsisTaskOutput;
import com.azure.resourcemanager.datamigration.models.MigrationState;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import com.azure.resourcemanager.datamigration.models.SsisMigrationStage;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigrateSsisTaskOutputProjectLevel
extends MigrateSsisTaskOutput {
    private String resultType = "SsisProjectLevelOutput";
    private String folderName;
    private String projectName;
    private MigrationState state;
    private SsisMigrationStage stage;
    private OffsetDateTime startedOn;
    private OffsetDateTime endedOn;
    private String message;
    private List<ReportableException> exceptionsAndWarnings;

    @Override
    public String resultType() {
        return this.resultType;
    }

    public String folderName() {
        return this.folderName;
    }

    public String projectName() {
        return this.projectName;
    }

    public MigrationState state() {
        return this.state;
    }

    public SsisMigrationStage stage() {
        return this.stage;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public OffsetDateTime endedOn() {
        return this.endedOn;
    }

    public String message() {
        return this.message;
    }

    public List<ReportableException> exceptionsAndWarnings() {
        return this.exceptionsAndWarnings;
    }

    @Override
    public void validate() {
        if (this.exceptionsAndWarnings() != null) {
            this.exceptionsAndWarnings().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultType", this.resultType);
        return jsonWriter.writeEndObject();
    }

    public static MigrateSsisTaskOutputProjectLevel fromJson(JsonReader jsonReader) throws IOException {
        return (MigrateSsisTaskOutputProjectLevel)jsonReader.readObject(reader -> {
            MigrateSsisTaskOutputProjectLevel deserializedMigrateSsisTaskOutputProjectLevel = new MigrateSsisTaskOutputProjectLevel();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.withId(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.resultType = reader.getString();
                    continue;
                }
                if ("folderName".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.folderName = reader.getString();
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.projectName = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.state = MigrationState.fromString(reader.getString());
                    continue;
                }
                if ("stage".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.stage = SsisMigrationStage.fromString(reader.getString());
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endedOn".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.endedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedMigrateSsisTaskOutputProjectLevel.message = reader.getString();
                    continue;
                }
                if ("exceptionsAndWarnings".equals(fieldName)) {
                    List exceptionsAndWarnings;
                    deserializedMigrateSsisTaskOutputProjectLevel.exceptionsAndWarnings = exceptionsAndWarnings = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigrateSsisTaskOutputProjectLevel;
        });
    }
}

