/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput;
import com.azure.resourcemanager.datamigration.models.PostgreSqlConnectionInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput
implements JsonSerializable<MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput> {
    private List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput> selectedDatabases;
    private PostgreSqlConnectionInfo targetConnectionInfo;
    private PostgreSqlConnectionInfo sourceConnectionInfo;
    private String encryptedKeyForSecureFields;
    private OffsetDateTime startedOn;
    private static final ClientLogger LOGGER = new ClientLogger(MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.class);

    public List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput> selectedDatabases() {
        return this.selectedDatabases;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput withSelectedDatabases(List<MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public PostgreSqlConnectionInfo targetConnectionInfo() {
        return this.targetConnectionInfo;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput withTargetConnectionInfo(PostgreSqlConnectionInfo targetConnectionInfo) {
        this.targetConnectionInfo = targetConnectionInfo;
        return this;
    }

    public PostgreSqlConnectionInfo sourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput withSourceConnectionInfo(PostgreSqlConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    public OffsetDateTime startedOn() {
        return this.startedOn;
    }

    public void validate() {
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"));
        }
        this.selectedDatabases().forEach(e -> e.validate());
        if (this.targetConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property targetConnectionInfo in model MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"));
        }
        this.targetConnectionInfo().validate();
        if (this.sourceConnectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceConnectionInfo in model MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput"));
        }
        this.sourceConnectionInfo().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("targetConnectionInfo", (JsonSerializable)this.targetConnectionInfo);
        jsonWriter.writeJsonField("sourceConnectionInfo", (JsonSerializable)this.sourceConnectionInfo);
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput)jsonReader.readObject(reader -> {
            MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput = new MigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> MigratePostgreSqlAzureDbForPostgreSqlSyncDatabaseInput.fromJson(reader1));
                    continue;
                }
                if ("targetConnectionInfo".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.targetConnectionInfo = PostgreSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("sourceConnectionInfo".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.sourceConnectionInfo = PostgreSqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                if ("startedOn".equals(fieldName)) {
                    deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput.startedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMigratePostgreSqlAzureDbForPostgreSqlSyncTaskInput;
        });
    }
}

