/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ServiceScalability;
import java.io.IOException;

public final class AvailableServiceSkuCapacity
implements JsonSerializable<AvailableServiceSkuCapacity> {
    private Integer minimum;
    private Integer maximum;
    private Integer defaultProperty;
    private ServiceScalability scaleType;

    public Integer minimum() {
        return this.minimum;
    }

    public AvailableServiceSkuCapacity withMinimum(Integer minimum) {
        this.minimum = minimum;
        return this;
    }

    public Integer maximum() {
        return this.maximum;
    }

    public AvailableServiceSkuCapacity withMaximum(Integer maximum) {
        this.maximum = maximum;
        return this;
    }

    public Integer defaultProperty() {
        return this.defaultProperty;
    }

    public AvailableServiceSkuCapacity withDefaultProperty(Integer defaultProperty) {
        this.defaultProperty = defaultProperty;
        return this;
    }

    public ServiceScalability scaleType() {
        return this.scaleType;
    }

    public AvailableServiceSkuCapacity withScaleType(ServiceScalability scaleType) {
        this.scaleType = scaleType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("minimum", (Number)this.minimum);
        jsonWriter.writeNumberField("maximum", (Number)this.maximum);
        jsonWriter.writeNumberField("default", (Number)this.defaultProperty);
        jsonWriter.writeStringField("scaleType", this.scaleType == null ? null : this.scaleType.toString());
        return jsonWriter.writeEndObject();
    }

    public static AvailableServiceSkuCapacity fromJson(JsonReader jsonReader) throws IOException {
        return (AvailableServiceSkuCapacity)jsonReader.readObject(reader -> {
            AvailableServiceSkuCapacity deserializedAvailableServiceSkuCapacity = new AvailableServiceSkuCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minimum".equals(fieldName)) {
                    deserializedAvailableServiceSkuCapacity.minimum = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maximum".equals(fieldName)) {
                    deserializedAvailableServiceSkuCapacity.maximum = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("default".equals(fieldName)) {
                    deserializedAvailableServiceSkuCapacity.defaultProperty = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("scaleType".equals(fieldName)) {
                    deserializedAvailableServiceSkuCapacity.scaleType = ServiceScalability.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAvailableServiceSkuCapacity;
        });
    }
}

