/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectFileInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.FileStorageInfo;
import com.azure.resourcemanager.datamigration.models.ProjectFile;
import com.azure.resourcemanager.datamigration.models.ProjectFileProperties;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;

public final class ProjectFileImpl
implements ProjectFile,
ProjectFile.Definition,
ProjectFile.Update {
    private ProjectFileInner innerObject;
    private final DataMigrationManager serviceManager;
    private String groupName;
    private String serviceName;
    private String projectName;
    private String fileName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ProjectFileProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.groupName;
    }

    @Override
    public ProjectFileInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ProjectFileImpl withExistingProject(String groupName, String serviceName, String projectName) {
        this.groupName = groupName;
        this.serviceName = serviceName;
        this.projectName = projectName;
        return this;
    }

    @Override
    public ProjectFile create() {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectFile create(Context context) {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().createOrUpdateWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectFileImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new ProjectFileInner();
        this.serviceManager = serviceManager;
        this.fileName = name;
    }

    @Override
    public ProjectFileImpl update() {
        return this;
    }

    @Override
    public ProjectFile apply() {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectFile apply(Context context) {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().updateWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, this.innerModel(), context).getValue());
        return this;
    }

    ProjectFileImpl(ProjectFileInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.groupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serviceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "services");
        this.projectName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "projects");
        this.fileName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "files");
    }

    @Override
    public ProjectFile refresh() {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().getWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ProjectFile refresh(Context context) {
        this.innerObject = (ProjectFileInner)((Object)this.serviceManager.serviceClient().getFiles().getWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, context).getValue());
        return this;
    }

    @Override
    public Response<FileStorageInfo> readWithResponse(Context context) {
        return this.serviceManager.files().readWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, context);
    }

    @Override
    public FileStorageInfo read() {
        return this.serviceManager.files().read(this.groupName, this.serviceName, this.projectName, this.fileName);
    }

    @Override
    public Response<FileStorageInfo> readWriteWithResponse(Context context) {
        return this.serviceManager.files().readWriteWithResponse(this.groupName, this.serviceName, this.projectName, this.fileName, context);
    }

    @Override
    public FileStorageInfo readWrite() {
        return this.serviceManager.files().readWrite(this.groupName, this.serviceName, this.projectName, this.fileName);
    }

    @Override
    public ProjectFileImpl withEtag(String etag) {
        this.innerModel().withEtag(etag);
        return this;
    }

    @Override
    public ProjectFileImpl withProperties(ProjectFileProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

