/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.OperationsClient;
import com.azure.resourcemanager.datamigration.fluent.models.OperationsDefinitionInner;
import com.azure.resourcemanager.datamigration.implementation.OperationsDefinitionImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.Operations;
import com.azure.resourcemanager.datamigration.models.OperationsDefinition;

public final class OperationsImpl
implements Operations {
    private static final ClientLogger LOGGER = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final DataMigrationManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<OperationsDefinition> list() {
        PagedIterable<OperationsDefinitionInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<OperationsDefinition> list(Context context) {
        PagedIterable<OperationsDefinitionInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new OperationsDefinitionImpl((OperationsDefinitionInner)inner1, this.manager()));
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }
}

