/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlMisClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlMiInner;
import com.azure.resourcemanager.datamigration.implementation.DatabaseMigrationSqlMiImpl;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlMi;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationsSqlMis;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.util.UUID;

public final class DatabaseMigrationsSqlMisImpl
implements DatabaseMigrationsSqlMis {
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsSqlMisImpl.class);
    private final DatabaseMigrationsSqlMisClient innerClient;
    private final DataMigrationManager serviceManager;

    public DatabaseMigrationsSqlMisImpl(DatabaseMigrationsSqlMisClient innerClient, DataMigrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DatabaseMigrationSqlMi> getWithResponse(String resourceGroupName, String managedInstanceName, String targetDbName, UUID migrationOperationId, String expand, Context context) {
        Response<DatabaseMigrationSqlMiInner> inner = this.serviceClient().getWithResponse(resourceGroupName, managedInstanceName, targetDbName, migrationOperationId, expand, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DatabaseMigrationSqlMiImpl((DatabaseMigrationSqlMiInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlMi get(String resourceGroupName, String managedInstanceName, String targetDbName) {
        DatabaseMigrationSqlMiInner inner = this.serviceClient().get(resourceGroupName, managedInstanceName, targetDbName);
        if (inner != null) {
            return new DatabaseMigrationSqlMiImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlMi delete(String resourceGroupName, String managedInstanceName, String targetDbName) {
        DatabaseMigrationSqlMiInner inner = this.serviceClient().delete(resourceGroupName, managedInstanceName, targetDbName);
        if (inner != null) {
            return new DatabaseMigrationSqlMiImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public DatabaseMigrationSqlMi delete(String resourceGroupName, String managedInstanceName, String targetDbName, Boolean force, Context context) {
        DatabaseMigrationSqlMiInner inner = this.serviceClient().delete(resourceGroupName, managedInstanceName, targetDbName, force, context);
        if (inner != null) {
            return new DatabaseMigrationSqlMiImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void cancel(String resourceGroupName, String managedInstanceName, String targetDbName, MigrationOperationInput parameters) {
        this.serviceClient().cancel(resourceGroupName, managedInstanceName, targetDbName, parameters);
    }

    @Override
    public void cancel(String resourceGroupName, String managedInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.serviceClient().cancel(resourceGroupName, managedInstanceName, targetDbName, parameters, context);
    }

    @Override
    public void cutover(String resourceGroupName, String managedInstanceName, String targetDbName, MigrationOperationInput parameters) {
        this.serviceClient().cutover(resourceGroupName, managedInstanceName, targetDbName, parameters);
    }

    @Override
    public void cutover(String resourceGroupName, String managedInstanceName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.serviceClient().cutover(resourceGroupName, managedInstanceName, targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlMi getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String managedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "managedInstances");
        if (managedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedInstances'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        UUID localMigrationOperationId = null;
        String localExpand = null;
        return (DatabaseMigrationSqlMi)this.getWithResponse(resourceGroupName, managedInstanceName, targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue();
    }

    @Override
    public Response<DatabaseMigrationSqlMi> getByIdWithResponse(String id, UUID migrationOperationId, String expand, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String managedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "managedInstances");
        if (managedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedInstances'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, managedInstanceName, targetDbName, migrationOperationId, expand, context);
    }

    @Override
    public DatabaseMigrationSqlMi deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String managedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "managedInstances");
        if (managedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedInstances'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        Boolean localForce = null;
        return this.delete(resourceGroupName, managedInstanceName, targetDbName, localForce, Context.NONE);
    }

    @Override
    public DatabaseMigrationSqlMi deleteByIdWithResponse(String id, Boolean force, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String managedInstanceName = ResourceManagerUtils.getValueFromIdByName(id, "managedInstances");
        if (managedInstanceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedInstances'.", id)));
        }
        String targetDbName = ResourceManagerUtils.getValueFromIdByName(id, "databaseMigrations");
        if (targetDbName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'databaseMigrations'.", id)));
        }
        return this.delete(resourceGroupName, managedInstanceName, targetDbName, force, context);
    }

    private DatabaseMigrationsSqlMisClient serviceClient() {
        return this.innerClient;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlMiImpl define(String name) {
        return new DatabaseMigrationSqlMiImpl(name, this.manager());
    }
}

