/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.DatabaseBackupInfo;
import com.azure.resourcemanager.datamigration.models.ReportableException;
import java.io.IOException;
import java.util.List;

public final class ValidateMigrationInputSqlServerSqlMITaskOutput
implements JsonSerializable<ValidateMigrationInputSqlServerSqlMITaskOutput> {
    private String id;
    private String name;
    private List<ReportableException> restoreDatabaseNameErrors;
    private List<ReportableException> backupFolderErrors;
    private List<ReportableException> backupShareCredentialsErrors;
    private List<ReportableException> backupStorageAccountErrors;
    private List<ReportableException> existingBackupErrors;
    private DatabaseBackupInfo databaseBackupInfo;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<ReportableException> restoreDatabaseNameErrors() {
        return this.restoreDatabaseNameErrors;
    }

    public List<ReportableException> backupFolderErrors() {
        return this.backupFolderErrors;
    }

    public List<ReportableException> backupShareCredentialsErrors() {
        return this.backupShareCredentialsErrors;
    }

    public List<ReportableException> backupStorageAccountErrors() {
        return this.backupStorageAccountErrors;
    }

    public List<ReportableException> existingBackupErrors() {
        return this.existingBackupErrors;
    }

    public DatabaseBackupInfo databaseBackupInfo() {
        return this.databaseBackupInfo;
    }

    public ValidateMigrationInputSqlServerSqlMITaskOutput withDatabaseBackupInfo(DatabaseBackupInfo databaseBackupInfo) {
        this.databaseBackupInfo = databaseBackupInfo;
        return this;
    }

    public void validate() {
        if (this.restoreDatabaseNameErrors() != null) {
            this.restoreDatabaseNameErrors().forEach(e -> e.validate());
        }
        if (this.backupFolderErrors() != null) {
            this.backupFolderErrors().forEach(e -> e.validate());
        }
        if (this.backupShareCredentialsErrors() != null) {
            this.backupShareCredentialsErrors().forEach(e -> e.validate());
        }
        if (this.backupStorageAccountErrors() != null) {
            this.backupStorageAccountErrors().forEach(e -> e.validate());
        }
        if (this.existingBackupErrors() != null) {
            this.existingBackupErrors().forEach(e -> e.validate());
        }
        if (this.databaseBackupInfo() != null) {
            this.databaseBackupInfo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("databaseBackupInfo", (JsonSerializable)this.databaseBackupInfo);
        return jsonWriter.writeEndObject();
    }

    public static ValidateMigrationInputSqlServerSqlMITaskOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ValidateMigrationInputSqlServerSqlMITaskOutput)jsonReader.readObject(reader -> {
            ValidateMigrationInputSqlServerSqlMITaskOutput deserializedValidateMigrationInputSqlServerSqlMITaskOutput = new ValidateMigrationInputSqlServerSqlMITaskOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.name = reader.getString();
                    continue;
                }
                if ("restoreDatabaseNameErrors".equals(fieldName)) {
                    List restoreDatabaseNameErrors;
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.restoreDatabaseNameErrors = restoreDatabaseNameErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("backupFolderErrors".equals(fieldName)) {
                    List backupFolderErrors;
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.backupFolderErrors = backupFolderErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("backupShareCredentialsErrors".equals(fieldName)) {
                    List backupShareCredentialsErrors;
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.backupShareCredentialsErrors = backupShareCredentialsErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("backupStorageAccountErrors".equals(fieldName)) {
                    List backupStorageAccountErrors;
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.backupStorageAccountErrors = backupStorageAccountErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("existingBackupErrors".equals(fieldName)) {
                    List existingBackupErrors;
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.existingBackupErrors = existingBackupErrors = reader.readArray(reader1 -> ReportableException.fromJson(reader1));
                    continue;
                }
                if ("databaseBackupInfo".equals(fieldName)) {
                    deserializedValidateMigrationInputSqlServerSqlMITaskOutput.databaseBackupInfo = DatabaseBackupInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedValidateMigrationInputSqlServerSqlMITaskOutput;
        });
    }
}

