/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.QueryExecutionResult;
import com.azure.resourcemanager.datamigration.models.ValidationError;
import java.io.IOException;

public final class QueryAnalysisValidationResult
implements JsonSerializable<QueryAnalysisValidationResult> {
    private QueryExecutionResult queryResults;
    private ValidationError validationErrors;

    public QueryExecutionResult queryResults() {
        return this.queryResults;
    }

    public QueryAnalysisValidationResult withQueryResults(QueryExecutionResult queryResults) {
        this.queryResults = queryResults;
        return this;
    }

    public ValidationError validationErrors() {
        return this.validationErrors;
    }

    public QueryAnalysisValidationResult withValidationErrors(ValidationError validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public void validate() {
        if (this.queryResults() != null) {
            this.queryResults().validate();
        }
        if (this.validationErrors() != null) {
            this.validationErrors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("queryResults", (JsonSerializable)this.queryResults);
        jsonWriter.writeJsonField("validationErrors", (JsonSerializable)this.validationErrors);
        return jsonWriter.writeEndObject();
    }

    public static QueryAnalysisValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (QueryAnalysisValidationResult)jsonReader.readObject(reader -> {
            QueryAnalysisValidationResult deserializedQueryAnalysisValidationResult = new QueryAnalysisValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queryResults".equals(fieldName)) {
                    deserializedQueryAnalysisValidationResult.queryResults = QueryExecutionResult.fromJson(reader);
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    deserializedQueryAnalysisValidationResult.validationErrors = ValidationError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryAnalysisValidationResult;
        });
    }
}

