/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.fluent.models.ProjectInner;
import com.azure.resourcemanager.datamigration.models.AzureActiveDirectoryApp;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import com.azure.resourcemanager.datamigration.models.DatabaseInfo;
import com.azure.resourcemanager.datamigration.models.ProjectProvisioningState;
import com.azure.resourcemanager.datamigration.models.ProjectSourcePlatform;
import com.azure.resourcemanager.datamigration.models.ProjectTargetPlatform;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface Project {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public SystemDataAutoGenerated systemData();

    public ProjectSourcePlatform sourcePlatform();

    public AzureActiveDirectoryApp azureAuthenticationInfo();

    public ProjectTargetPlatform targetPlatform();

    public OffsetDateTime creationTime();

    public ConnectionInfo sourceConnectionInfo();

    public ConnectionInfo targetConnectionInfo();

    public List<DatabaseInfo> databasesInfo();

    public ProjectProvisioningState provisioningState();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ProjectInner innerModel();

    public Update update();

    public Project refresh();

    public Project refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithDatabasesInfo {
            public Update withDatabasesInfo(List<DatabaseInfo> var1);
        }

        public static interface WithTargetConnectionInfo {
            public Update withTargetConnectionInfo(ConnectionInfo var1);
        }

        public static interface WithSourceConnectionInfo {
            public Update withSourceConnectionInfo(ConnectionInfo var1);
        }

        public static interface WithTargetPlatform {
            public Update withTargetPlatform(ProjectTargetPlatform var1);
        }

        public static interface WithAzureAuthenticationInfo {
            public Update withAzureAuthenticationInfo(AzureActiveDirectoryApp var1);
        }

        public static interface WithSourcePlatform {
            public Update withSourcePlatform(ProjectSourcePlatform var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEtag,
    UpdateStages.WithSourcePlatform,
    UpdateStages.WithAzureAuthenticationInfo,
    UpdateStages.WithTargetPlatform,
    UpdateStages.WithSourceConnectionInfo,
    UpdateStages.WithTargetConnectionInfo,
    UpdateStages.WithDatabasesInfo {
        public Project apply();

        public Project apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDatabasesInfo {
            public WithCreate withDatabasesInfo(List<DatabaseInfo> var1);
        }

        public static interface WithTargetConnectionInfo {
            public WithCreate withTargetConnectionInfo(ConnectionInfo var1);
        }

        public static interface WithSourceConnectionInfo {
            public WithCreate withSourceConnectionInfo(ConnectionInfo var1);
        }

        public static interface WithTargetPlatform {
            public WithCreate withTargetPlatform(ProjectTargetPlatform var1);
        }

        public static interface WithAzureAuthenticationInfo {
            public WithCreate withAzureAuthenticationInfo(AzureActiveDirectoryApp var1);
        }

        public static interface WithSourcePlatform {
            public WithCreate withSourcePlatform(ProjectSourcePlatform var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithSourcePlatform,
        WithAzureAuthenticationInfo,
        WithTargetPlatform,
        WithSourceConnectionInfo,
        WithTargetConnectionInfo,
        WithDatabasesInfo {
            public Project create();

            public Project create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingService(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

