/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OfflineConfiguration
implements JsonSerializable<OfflineConfiguration> {
    private Boolean offline;
    private String lastBackupName;

    public Boolean offline() {
        return this.offline;
    }

    public OfflineConfiguration withOffline(Boolean offline) {
        this.offline = offline;
        return this;
    }

    public String lastBackupName() {
        return this.lastBackupName;
    }

    public OfflineConfiguration withLastBackupName(String lastBackupName) {
        this.lastBackupName = lastBackupName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("offline", this.offline);
        jsonWriter.writeStringField("lastBackupName", this.lastBackupName);
        return jsonWriter.writeEndObject();
    }

    public static OfflineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (OfflineConfiguration)jsonReader.readObject(reader -> {
            OfflineConfiguration deserializedOfflineConfiguration = new OfflineConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("offline".equals(fieldName)) {
                    deserializedOfflineConfiguration.offline = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastBackupName".equals(fieldName)) {
                    deserializedOfflineConfiguration.lastBackupName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOfflineConfiguration;
        });
    }
}

