/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.AuthenticationType;
import com.azure.resourcemanager.datamigration.models.ConnectionInfo;
import java.io.IOException;

public final class MySqlConnectionInfo
extends ConnectionInfo {
    private String type = "MySqlConnectionInfo";
    private String serverName;
    private String dataSource;
    private int port;
    private Boolean encryptConnection;
    private AuthenticationType authentication;
    private String additionalSettings;
    private static final ClientLogger LOGGER = new ClientLogger(MySqlConnectionInfo.class);

    @Override
    public String type() {
        return this.type;
    }

    public String serverName() {
        return this.serverName;
    }

    public MySqlConnectionInfo withServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public String dataSource() {
        return this.dataSource;
    }

    public MySqlConnectionInfo withDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public int port() {
        return this.port;
    }

    public MySqlConnectionInfo withPort(int port) {
        this.port = port;
        return this;
    }

    public Boolean encryptConnection() {
        return this.encryptConnection;
    }

    public MySqlConnectionInfo withEncryptConnection(Boolean encryptConnection) {
        this.encryptConnection = encryptConnection;
        return this;
    }

    public AuthenticationType authentication() {
        return this.authentication;
    }

    public MySqlConnectionInfo withAuthentication(AuthenticationType authentication) {
        this.authentication = authentication;
        return this;
    }

    public String additionalSettings() {
        return this.additionalSettings;
    }

    public MySqlConnectionInfo withAdditionalSettings(String additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @Override
    public MySqlConnectionInfo withUsername(String username) {
        super.withUsername(username);
        return this;
    }

    @Override
    public MySqlConnectionInfo withPassword(String password) {
        super.withPassword(password);
        return this;
    }

    @Override
    public void validate() {
        if (this.serverName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverName in model MySqlConnectionInfo"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username());
        jsonWriter.writeStringField("password", this.password());
        jsonWriter.writeStringField("serverName", this.serverName);
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeBooleanField("encryptConnection", this.encryptConnection);
        jsonWriter.writeStringField("authentication", this.authentication == null ? null : this.authentication.toString());
        jsonWriter.writeStringField("additionalSettings", this.additionalSettings);
        return jsonWriter.writeEndObject();
    }

    public static MySqlConnectionInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MySqlConnectionInfo)jsonReader.readObject(reader -> {
            MySqlConnectionInfo deserializedMySqlConnectionInfo = new MySqlConnectionInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userName".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.withUsername(reader.getString());
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.withPassword(reader.getString());
                    continue;
                }
                if ("serverName".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.serverName = reader.getString();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.port = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.type = reader.getString();
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.dataSource = reader.getString();
                    continue;
                }
                if ("encryptConnection".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.encryptConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("authentication".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.authentication = AuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("additionalSettings".equals(fieldName)) {
                    deserializedMySqlConnectionInfo.additionalSettings = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMySqlConnectionInfo;
        });
    }
}

