/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbShardKeyField;
import java.io.IOException;
import java.util.List;

public final class MongoDbShardKeySetting
implements JsonSerializable<MongoDbShardKeySetting> {
    private List<MongoDbShardKeyField> fields;
    private Boolean isUnique;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbShardKeySetting.class);

    public List<MongoDbShardKeyField> fields() {
        return this.fields;
    }

    public MongoDbShardKeySetting withFields(List<MongoDbShardKeyField> fields) {
        this.fields = fields;
        return this;
    }

    public Boolean isUnique() {
        return this.isUnique;
    }

    public MongoDbShardKeySetting withIsUnique(Boolean isUnique) {
        this.isUnique = isUnique;
        return this;
    }

    public void validate() {
        if (this.fields() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property fields in model MongoDbShardKeySetting"));
        }
        this.fields().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("fields", this.fields, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isUnique", this.isUnique);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbShardKeySetting fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbShardKeySetting)jsonReader.readObject(reader -> {
            MongoDbShardKeySetting deserializedMongoDbShardKeySetting = new MongoDbShardKeySetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fields".equals(fieldName)) {
                    List fields;
                    deserializedMongoDbShardKeySetting.fields = fields = reader.readArray(reader1 -> MongoDbShardKeyField.fromJson(reader1));
                    continue;
                }
                if ("isUnique".equals(fieldName)) {
                    deserializedMongoDbShardKeySetting.isUnique = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbShardKeySetting;
        });
    }
}

