/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbCollectionProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbDatabaseProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbError;
import com.azure.resourcemanager.datamigration.models.MongoDbMigrationProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbMigrationState;
import com.azure.resourcemanager.datamigration.models.MongoDbProgressResultType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class MongoDbProgress
implements JsonSerializable<MongoDbProgress> {
    private MongoDbProgressResultType resultType = MongoDbProgressResultType.fromString("MongoDbProgress");
    private long bytesCopied;
    private long documentsCopied;
    private String elapsedTime;
    private Map<String, MongoDbError> errors;
    private long eventsPending;
    private long eventsReplayed;
    private OffsetDateTime lastEventTime;
    private OffsetDateTime lastReplayTime;
    private String name;
    private String qualifiedName;
    private MongoDbMigrationState state;
    private long totalBytes;
    private long totalDocuments;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbProgress.class);

    public MongoDbProgressResultType resultType() {
        return this.resultType;
    }

    public long bytesCopied() {
        return this.bytesCopied;
    }

    public MongoDbProgress withBytesCopied(long bytesCopied) {
        this.bytesCopied = bytesCopied;
        return this;
    }

    public long documentsCopied() {
        return this.documentsCopied;
    }

    public MongoDbProgress withDocumentsCopied(long documentsCopied) {
        this.documentsCopied = documentsCopied;
        return this;
    }

    public String elapsedTime() {
        return this.elapsedTime;
    }

    public MongoDbProgress withElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
        return this;
    }

    public Map<String, MongoDbError> errors() {
        return this.errors;
    }

    public MongoDbProgress withErrors(Map<String, MongoDbError> errors) {
        this.errors = errors;
        return this;
    }

    public long eventsPending() {
        return this.eventsPending;
    }

    public MongoDbProgress withEventsPending(long eventsPending) {
        this.eventsPending = eventsPending;
        return this;
    }

    public long eventsReplayed() {
        return this.eventsReplayed;
    }

    public MongoDbProgress withEventsReplayed(long eventsReplayed) {
        this.eventsReplayed = eventsReplayed;
        return this;
    }

    public OffsetDateTime lastEventTime() {
        return this.lastEventTime;
    }

    public MongoDbProgress withLastEventTime(OffsetDateTime lastEventTime) {
        this.lastEventTime = lastEventTime;
        return this;
    }

    public OffsetDateTime lastReplayTime() {
        return this.lastReplayTime;
    }

    public MongoDbProgress withLastReplayTime(OffsetDateTime lastReplayTime) {
        this.lastReplayTime = lastReplayTime;
        return this;
    }

    public String name() {
        return this.name;
    }

    public MongoDbProgress withName(String name) {
        this.name = name;
        return this;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public MongoDbProgress withQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
        return this;
    }

    public MongoDbMigrationState state() {
        return this.state;
    }

    public MongoDbProgress withState(MongoDbMigrationState state) {
        this.state = state;
        return this;
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public MongoDbProgress withTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
        return this;
    }

    public long totalDocuments() {
        return this.totalDocuments;
    }

    public MongoDbProgress withTotalDocuments(long totalDocuments) {
        this.totalDocuments = totalDocuments;
        return this;
    }

    public void validate() {
        if (this.elapsedTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elapsedTime in model MongoDbProgress"));
        }
        if (this.errors() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property errors in model MongoDbProgress"));
        }
        this.errors().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model MongoDbProgress"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("bytesCopied", this.bytesCopied);
        jsonWriter.writeLongField("documentsCopied", this.documentsCopied);
        jsonWriter.writeStringField("elapsedTime", this.elapsedTime);
        jsonWriter.writeMapField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("eventsPending", this.eventsPending);
        jsonWriter.writeLongField("eventsReplayed", this.eventsReplayed);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeLongField("totalBytes", this.totalBytes);
        jsonWriter.writeLongField("totalDocuments", this.totalDocuments);
        jsonWriter.writeStringField("resultType", this.resultType == null ? null : this.resultType.toString());
        jsonWriter.writeStringField("lastEventTime", this.lastEventTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEventTime));
        jsonWriter.writeStringField("lastReplayTime", this.lastReplayTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastReplayTime));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbProgress fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbProgress)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MongoDbProgress mongoDbProgress;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("resultType".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Collection".equals(discriminatorValue)) {
                    mongoDbProgress = MongoDbCollectionProgress.fromJson(readerToUse.reset());
                    return mongoDbProgress;
                }
                if ("Database".equals(discriminatorValue)) {
                    mongoDbProgress = MongoDbDatabaseProgress.fromJson(readerToUse.reset());
                    return mongoDbProgress;
                }
                if ("Migration".equals(discriminatorValue)) {
                    mongoDbProgress = MongoDbMigrationProgress.fromJson(readerToUse.reset());
                    return mongoDbProgress;
                }
                mongoDbProgress = MongoDbProgress.fromJsonKnownDiscriminator(readerToUse.reset());
                return mongoDbProgress;
            }
        });
    }

    static MongoDbProgress fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MongoDbProgress)jsonReader.readObject(reader -> {
            MongoDbProgress deserializedMongoDbProgress = new MongoDbProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bytesCopied".equals(fieldName)) {
                    deserializedMongoDbProgress.bytesCopied = reader.getLong();
                    continue;
                }
                if ("documentsCopied".equals(fieldName)) {
                    deserializedMongoDbProgress.documentsCopied = reader.getLong();
                    continue;
                }
                if ("elapsedTime".equals(fieldName)) {
                    deserializedMongoDbProgress.elapsedTime = reader.getString();
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    Map errors;
                    deserializedMongoDbProgress.errors = errors = reader.readMap(reader1 -> MongoDbError.fromJson(reader1));
                    continue;
                }
                if ("eventsPending".equals(fieldName)) {
                    deserializedMongoDbProgress.eventsPending = reader.getLong();
                    continue;
                }
                if ("eventsReplayed".equals(fieldName)) {
                    deserializedMongoDbProgress.eventsReplayed = reader.getLong();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMongoDbProgress.state = MongoDbMigrationState.fromString(reader.getString());
                    continue;
                }
                if ("totalBytes".equals(fieldName)) {
                    deserializedMongoDbProgress.totalBytes = reader.getLong();
                    continue;
                }
                if ("totalDocuments".equals(fieldName)) {
                    deserializedMongoDbProgress.totalDocuments = reader.getLong();
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMongoDbProgress.resultType = MongoDbProgressResultType.fromString(reader.getString());
                    continue;
                }
                if ("lastEventTime".equals(fieldName)) {
                    deserializedMongoDbProgress.lastEventTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastReplayTime".equals(fieldName)) {
                    deserializedMongoDbProgress.lastReplayTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbProgress.name = reader.getString();
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbProgress.qualifiedName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbProgress;
        });
    }
}

