/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbCollectionSettings;
import java.io.IOException;
import java.util.Map;

public final class MongoDbDatabaseSettings
implements JsonSerializable<MongoDbDatabaseSettings> {
    private Map<String, MongoDbCollectionSettings> collections;
    private Integer targetRUs;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbDatabaseSettings.class);

    public Map<String, MongoDbCollectionSettings> collections() {
        return this.collections;
    }

    public MongoDbDatabaseSettings withCollections(Map<String, MongoDbCollectionSettings> collections) {
        this.collections = collections;
        return this;
    }

    public Integer targetRUs() {
        return this.targetRUs;
    }

    public MongoDbDatabaseSettings withTargetRUs(Integer targetRUs) {
        this.targetRUs = targetRUs;
        return this;
    }

    public void validate() {
        if (this.collections() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property collections in model MongoDbDatabaseSettings"));
        }
        this.collections().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("collections", this.collections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("targetRUs", (Number)this.targetRUs);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbDatabaseSettings fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbDatabaseSettings)jsonReader.readObject(reader -> {
            MongoDbDatabaseSettings deserializedMongoDbDatabaseSettings = new MongoDbDatabaseSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("collections".equals(fieldName)) {
                    Map collections;
                    deserializedMongoDbDatabaseSettings.collections = collections = reader.readMap(reader1 -> MongoDbCollectionSettings.fromJson(reader1));
                    continue;
                }
                if ("targetRUs".equals(fieldName)) {
                    deserializedMongoDbDatabaseSettings.targetRUs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbDatabaseSettings;
        });
    }
}

