/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.MongoDbError;
import com.azure.resourcemanager.datamigration.models.MongoDbMigrationState;
import com.azure.resourcemanager.datamigration.models.MongoDbProgress;
import com.azure.resourcemanager.datamigration.models.MongoDbProgressResultType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class MongoDbCollectionProgress
extends MongoDbProgress {
    private MongoDbProgressResultType resultType = MongoDbProgressResultType.COLLECTION;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbCollectionProgress.class);

    @Override
    public MongoDbProgressResultType resultType() {
        return this.resultType;
    }

    @Override
    public MongoDbCollectionProgress withBytesCopied(long bytesCopied) {
        super.withBytesCopied(bytesCopied);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withDocumentsCopied(long documentsCopied) {
        super.withDocumentsCopied(documentsCopied);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withElapsedTime(String elapsedTime) {
        super.withElapsedTime(elapsedTime);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withErrors(Map<String, MongoDbError> errors) {
        super.withErrors(errors);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withEventsPending(long eventsPending) {
        super.withEventsPending(eventsPending);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withEventsReplayed(long eventsReplayed) {
        super.withEventsReplayed(eventsReplayed);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withLastEventTime(OffsetDateTime lastEventTime) {
        super.withLastEventTime(lastEventTime);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withLastReplayTime(OffsetDateTime lastReplayTime) {
        super.withLastReplayTime(lastReplayTime);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withQualifiedName(String qualifiedName) {
        super.withQualifiedName(qualifiedName);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withState(MongoDbMigrationState state) {
        super.withState(state);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withTotalBytes(long totalBytes) {
        super.withTotalBytes(totalBytes);
        return this;
    }

    @Override
    public MongoDbCollectionProgress withTotalDocuments(long totalDocuments) {
        super.withTotalDocuments(totalDocuments);
        return this;
    }

    @Override
    public void validate() {
        if (this.elapsedTime() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property elapsedTime in model MongoDbCollectionProgress"));
        }
        if (this.errors() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property errors in model MongoDbCollectionProgress"));
        }
        this.errors().values().forEach(e -> {
            if (e != null) {
                e.validate();
            }
        });
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model MongoDbCollectionProgress"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("bytesCopied", this.bytesCopied());
        jsonWriter.writeLongField("documentsCopied", this.documentsCopied());
        jsonWriter.writeStringField("elapsedTime", this.elapsedTime());
        jsonWriter.writeMapField("errors", this.errors(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeLongField("eventsPending", this.eventsPending());
        jsonWriter.writeLongField("eventsReplayed", this.eventsReplayed());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeLongField("totalBytes", this.totalBytes());
        jsonWriter.writeLongField("totalDocuments", this.totalDocuments());
        jsonWriter.writeStringField("lastEventTime", this.lastEventTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEventTime()));
        jsonWriter.writeStringField("lastReplayTime", this.lastReplayTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastReplayTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("qualifiedName", this.qualifiedName());
        jsonWriter.writeStringField("resultType", this.resultType == null ? null : this.resultType.toString());
        return jsonWriter.writeEndObject();
    }

    public static MongoDbCollectionProgress fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbCollectionProgress)jsonReader.readObject(reader -> {
            MongoDbCollectionProgress deserializedMongoDbCollectionProgress = new MongoDbCollectionProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("bytesCopied".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withBytesCopied(reader.getLong());
                    continue;
                }
                if ("documentsCopied".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withDocumentsCopied(reader.getLong());
                    continue;
                }
                if ("elapsedTime".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withElapsedTime(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    Map errors = reader.readMap(reader1 -> MongoDbError.fromJson(reader1));
                    deserializedMongoDbCollectionProgress.withErrors(errors);
                    continue;
                }
                if ("eventsPending".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withEventsPending(reader.getLong());
                    continue;
                }
                if ("eventsReplayed".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withEventsReplayed(reader.getLong());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withState(MongoDbMigrationState.fromString(reader.getString()));
                    continue;
                }
                if ("totalBytes".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withTotalBytes(reader.getLong());
                    continue;
                }
                if ("totalDocuments".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withTotalDocuments(reader.getLong());
                    continue;
                }
                if ("lastEventTime".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withLastEventTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastReplayTime".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withLastReplayTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withName(reader.getString());
                    continue;
                }
                if ("qualifiedName".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.withQualifiedName(reader.getString());
                    continue;
                }
                if ("resultType".equals(fieldName)) {
                    deserializedMongoDbCollectionProgress.resultType = MongoDbProgressResultType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbCollectionProgress;
        });
    }
}

